/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MapListModel;
import com.cburch.logisim.gui.generic.OptionPane;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ConstantButton
extends FpgaIoInformationContainer {
    public static final int CONSTANT_ZERO = 0;
    public static final int CONSTANT_ONE = 1;
    public static final int CONSTANT_VALUE = 2;
    public static final int LEAVE_OPEN = 3;
    public static final ConstantButton ZERO_BUTTON = new ConstantButton(0);
    public static final ConstantButton ONE_BUTTON = new ConstantButton(1);
    public static final ConstantButton VALUE_BUTTON = new ConstantButton(2);
    public static final ConstantButton OPEN_BUTTON = new ConstantButton(3);
    private final int myType;

    public ConstantButton(int type) {
        this.myType = type;
        this.myRectangle = new BoardRectangle(type * 185, 400, 185, 30);
    }

    @Override
    public boolean tryMap(JPanel parent) {
        if (this.selComp == null) {
            return false;
        }
        MapComponent map = this.selComp.getMap();
        return switch (this.myType) {
            case 0 -> map.tryConstantMap(this.selComp.getPin(), 0L);
            case 1 -> map.tryConstantMap(this.selComp.getPin(), -1L);
            case 3 -> map.tryOpenMap(this.selComp.getPin());
            case 2 -> this.getConstant(this.selComp.getPin(), map);
            default -> false;
        };
    }

    private boolean getConstant(int pin, MapComponent map) {
        boolean correct;
        long v = 0L;
        do {
            correct = true;
            String value = OptionPane.showInputDialog(Strings.S.get("FpgaMapSpecConst"));
            if (value == null) {
                return false;
            }
            if (value.startsWith("0x")) {
                try {
                    v = Long.parseLong(value.substring(2), 16);
                }
                catch (NumberFormatException e1) {
                    correct = false;
                }
            } else {
                try {
                    v = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    correct = false;
                }
            }
            if (correct) continue;
            OptionPane.showMessageDialog(null, Strings.S.get("FpgaMapSpecErr"));
        } while (!correct);
        return map.tryConstantMap(pin, v);
    }

    @Override
    public void paint(Graphics2D g, float scale) {
        super.paintSelected(g, scale);
    }

    @Override
    public boolean setSelectable(MapListModel.MapInfo comp) {
        this.selComp = comp;
        MapComponent map = comp.getMap();
        int connect = comp.getPin();
        if (connect < 0) {
            if (map.hasInputs()) {
                this.selectable = switch (this.myType) {
                    case 1 -> true;
                    case 0 -> true;
                    case 2 -> {
                        if (map.nrInputs() > 1) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> false;
                    default -> throw new IllegalStateException("Unexpected value: " + this.myType);
                };
            }
            if (map.hasOutputs() || map.hasIos()) {
                this.selectable = this.myType == 3;
            }
        } else {
            if (map.isInput(connect)) {
                boolean bl = this.selectable = this.myType == 0 || this.myType == 1;
            }
            if (map.isOutput(connect) || map.isIo(connect)) {
                this.selectable = this.myType == 3;
            }
        }
        return this.selectable;
    }
}

