/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.SplitterParameters;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

class SplitterPainter {
    private static final int SPINE_WIDTH = 5;
    private static final int SPINE_DOT = 7;

    SplitterPainter() {
    }

    static void drawLabels(ComponentDrawContext context, SplitterAttributes attrs, Location origin) {
        String[] ends = new String[attrs.fanout + 1];
        int curEnd = -1;
        int cur0 = 0;
        int n = attrs.bitEnd.length;
        for (int i = 0; i <= n; ++i) {
            int bit;
            int n2 = bit = i == n ? -1 : attrs.bitEnd[i];
            if (bit == curEnd) continue;
            int cur1 = i - 1;
            String toAdd = curEnd <= 0 ? null : (cur0 == cur1 ? "" + cur0 : cur1 + "-" + cur0);
            if (toAdd != null) {
                String old = ends[curEnd];
                ends[curEnd] = old == null ? toAdd : toAdd + "," + old;
            }
            curEnd = bit;
            cur0 = i;
        }
        Graphics g = context.getGraphics().create();
        Font font = g.getFont();
        g.setFont(font.deriveFont(7.0f));
        SplitterParameters parms = attrs.getParameters();
        int x = origin.getX() + parms.getEnd0X() + parms.getEndToSpineDeltaX();
        int y = origin.getY() + parms.getEnd0Y() + parms.getEndToSpineDeltaY();
        int dx = parms.getEndToEndDeltaX();
        int dy = parms.getEndToEndDeltaY();
        if (parms.getTextAngle() != 0) {
            ((Graphics2D)g).rotate(1.5707963267948966);
            int t = -x;
            x = y;
            y = t;
            t = -dx;
            dx = dy;
            dy = t;
        }
        int halign = parms.getTextHorzAlign();
        int valign = parms.getTextVertAlign();
        x += (halign == 1 ? -1 : 1) * 3;
        y += valign == -1 ? 0 : -3;
        int n3 = attrs.fanout;
        for (int i = 0; i < n3; ++i) {
            String text = ends[i + 1];
            if (text != null) {
                GraphicsUtil.drawText(g, text, x, y, halign, valign);
            }
            x += dx;
            y += dy;
        }
        g.dispose();
    }

    static void drawLegacy(ComponentDrawContext context, SplitterAttributes attrs, Location origin) {
        Graphics g = context.getGraphics();
        CircuitState state = context.getCircuitState();
        Direction facing = attrs.facing;
        int fanout = attrs.fanout;
        SplitterParameters parms = attrs.getParameters();
        g.setColor(Value.multiColor);
        int x0 = origin.getX();
        int y0 = origin.getY();
        int x1 = x0 + parms.getEnd0X();
        int y1 = y0 + parms.getEnd0Y();
        int dx = parms.getEndToEndDeltaX();
        int dy = parms.getEndToEndDeltaY();
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int ySpine = (y0 + y1) / 2;
            GraphicsUtil.switchToWidth(g, 3);
            g.drawLine(x0, y0, x0, ySpine);
            int xi = x1;
            int yi = y1;
            for (int i = 1; i <= fanout; ++i) {
                if (context.getShowState()) {
                    g.setColor(state.getValue(Location.create(xi, yi, true)).getColor());
                }
                int xSpine = xi + (xi == x0 ? 0 : (xi < x0 ? 10 : -10));
                g.drawLine(xi, yi, xSpine, ySpine);
                xi += dx;
                yi += dy;
            }
            if (fanout > 3) {
                GraphicsUtil.switchToWidth(g, 5);
                g.setColor(Value.multiColor);
                g.drawLine(x1 + (dx > 0 ? 10 : -10), ySpine, x1 + (fanout - 1) * dx + (dx > 0 ? 10 : -10), ySpine);
            } else {
                g.setColor(Value.multiColor);
                g.fillOval(x0 - 3, ySpine - 3, 7, 7);
            }
        } else {
            int xSpine = (x0 + x1) / 2;
            GraphicsUtil.switchToWidth(g, 3);
            g.drawLine(x0, y0, xSpine, y0);
            int xi = x1;
            int yi = y1;
            for (int i = 1; i <= fanout; ++i) {
                if (context.getShowState()) {
                    g.setColor(state.getValue(Location.create(xi, yi, true)).getColor());
                }
                int ySpine = yi + (yi == y0 ? 0 : (yi < y0 ? 10 : -10));
                g.drawLine(xi, yi, xSpine, ySpine);
                xi += dx;
                yi += dy;
            }
            if (fanout >= 3) {
                GraphicsUtil.switchToWidth(g, 5);
                g.setColor(Value.multiColor);
                g.drawLine(xSpine, y1 + (dy > 0 ? 10 : -10), xSpine, y1 + (fanout - 1) * dy + (dy > 0 ? 10 : -10));
            } else {
                g.setColor(Value.multiColor);
                g.fillOval(xSpine - 3, y0 - 3, 7, 7);
            }
        }
        GraphicsUtil.switchToWidth(g, 1);
    }

    static void drawLines(ComponentDrawContext context, SplitterAttributes attrs, Location origin) {
        CircuitState state;
        boolean showState = context.getShowState();
        CircuitState circuitState = state = showState ? context.getCircuitState() : null;
        if (state == null) {
            showState = false;
        }
        SplitterParameters parms = attrs.getParameters();
        int x0 = origin.getX();
        int y0 = origin.getY();
        int x = x0 + parms.getEnd0X();
        int y = y0 + parms.getEnd0Y();
        int dx = parms.getEndToEndDeltaX();
        int dy = parms.getEndToEndDeltaY();
        int dxEndSpine = parms.getEndToSpineDeltaX();
        int dyEndSpine = parms.getEndToSpineDeltaY();
        Graphics g = context.getGraphics();
        Color oldColor = g.getColor();
        GraphicsUtil.switchToWidth(g, 3);
        int n = attrs.fanout;
        for (int i = 0; i < n; ++i) {
            if (showState) {
                Value val = state.getValue(Location.create(x, y, true));
                g.setColor(val.getColor());
            }
            g.drawLine(x, y, x + dxEndSpine, y + dyEndSpine);
            x += dx;
            y += dy;
        }
        GraphicsUtil.switchToWidth(g, 5);
        g.setColor(Value.multiColor);
        int spine0x = x0 + parms.getSpine0X();
        int spine0y = y0 + parms.getSpine0Y();
        int spine1x = x0 + parms.getSpine1X();
        int spine1y = y0 + parms.getSpine1Y();
        if (spine0x == spine1x && spine0y == spine1y) {
            byte fanout = attrs.fanout;
            spine0x = x0 + parms.getEnd0X() + parms.getEndToSpineDeltaX();
            spine0y = y0 + parms.getEnd0Y() + parms.getEndToSpineDeltaY();
            spine1x = spine0x + (fanout - 1) * parms.getEndToEndDeltaX();
            spine1y = spine0y + (fanout - 1) * parms.getEndToEndDeltaY();
            if (parms.getEndToEndDeltaX() == 0) {
                if (spine0y < spine1y) {
                    ++spine0y;
                    --spine1y;
                } else {
                    --spine0y;
                    ++spine1y;
                }
                g.drawLine(x0 + parms.getSpine1X() / 4, y0, spine0x, y0);
            } else {
                if (spine0x < spine1x) {
                    ++spine0x;
                    --spine1x;
                } else {
                    --spine0x;
                    ++spine1x;
                }
                g.drawLine(x0, y0 + parms.getSpine1Y() / 4, x0, spine0y);
            }
            if (fanout <= 1) {
                int diam = 7;
                g.fillOval(spine0x - diam / 2, spine0y - diam / 2, diam, diam);
            } else {
                g.drawLine(spine0x, spine0y, spine1x, spine1y);
            }
        } else {
            int[] xSpine = new int[]{spine0x, spine1x, x0 + parms.getSpine1X() / 4};
            int[] ySpine = new int[]{spine0y, spine1y, y0 + parms.getSpine1Y() / 4};
            g.drawPolyline(xSpine, ySpine, 3);
        }
        g.setColor(oldColor);
    }
}

