/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringGetter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class SplitterDistributeItem
extends JMenuItem
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Project proj;
    private final Splitter splitter;
    private final int order;

    public SplitterDistributeItem(Project proj, Splitter splitter, int order) {
        this.proj = proj;
        this.splitter = splitter;
        this.order = order;
        this.addActionListener(this);
        SplitterAttributes attrs = (SplitterAttributes)splitter.getAttributeSet();
        byte[] actual = attrs.bitEnd;
        byte[] desired = SplitterAttributes.computeDistribution(attrs.fanout, actual.length, order);
        boolean same = actual.length == desired.length;
        for (int i = 0; same && i < desired.length; ++i) {
            if (actual[i] == desired[i]) continue;
            same = false;
        }
        this.setEnabled(!same);
        this.setText(this.toGetter().toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SplitterAttributes attrs = (SplitterAttributes)this.splitter.getAttributeSet();
        byte[] actual = attrs.bitEnd;
        byte[] desired = SplitterAttributes.computeDistribution(attrs.fanout, actual.length, this.order);
        CircuitMutation xn = new CircuitMutation(this.proj.getCircuitState().getCircuit());
        int n = Math.min(actual.length, desired.length);
        for (int i = 0; i < n; ++i) {
            if (actual[i] == desired[i]) continue;
            xn.set(this.splitter, attrs.getBitOutAttribute(i), desired[i]);
        }
        this.proj.doAction(xn.toAction(this.toGetter()));
    }

    private StringGetter toGetter() {
        if (this.order > 0) {
            return Strings.S.getter("splitterDistributeAscending");
        }
        return Strings.S.getter("splitterDistributeDescending");
    }
}

