/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.circuit.ComponentDataGuiProvider;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.io.TelnetServer;
import com.cburch.logisim.std.io.extra.Buzzer;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.memory.RamState;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Pin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CircuitState
implements InstanceData {
    private final MyCircuitListener myCircuitListener = new MyCircuitListener();
    private Propagator base = null;
    private final Project proj;
    private final Circuit circuit;
    private CircuitState parentState = null;
    private Component parentComp = null;
    private CircuitWires.State wireData = null;
    private final HashMap<Component, Object> componentData = new HashMap();
    private static final int FASTPATH_GRID_WIDTH = 200;
    private static final int FASTPATH_GRID_HEIGHT = 200;
    private Map<Location, Value> slowpathValues = new HashMap<Location, Value>();
    private Value[][] fastpathValues = new Value[200][200];
    private final Object valuesLock = new Object();
    private ArrayList<Component> dirtyComponents = new ArrayList();
    private ArrayList<Propagator.SimulatorEvent> dirtyPoints = new ArrayList();
    private HashSet<CircuitState> substates = new HashSet();
    private final Object dirtyLock = new Object();
    ArrayList<Component> dirtyComponentsWorking = new ArrayList();
    private ArrayList<Propagator.SimulatorEvent> dirtyPointsWorking = new ArrayList();
    private CircuitState[] substatesWorking = new CircuitState[0];
    private boolean substatesDirty = true;
    private static int lastId = 0;
    private final int id = lastId++;
    private InstanceStateImpl reusableInstanceState = new InstanceStateImpl(this, null);
    private boolean knownClocks;
    private Component temporaryClock;

    public CircuitState(Project proj, Circuit circuit, Propagator prop) {
        this.proj = proj;
        this.circuit = circuit;
        this.base = prop != null ? prop : new Propagator(this);
        circuit.addCircuitListener(this.myCircuitListener);
        this.markAllComponentsDirty();
    }

    @Override
    public CircuitState clone() {
        return this.cloneAsNewRootState();
    }

    public static CircuitState createRootState(Project proj, Circuit circuit) {
        return new CircuitState(proj, circuit, null);
    }

    public CircuitState cloneAsNewRootState() {
        CircuitState ret = new CircuitState(this.proj, this.circuit, null);
        ret.copyFrom(this);
        ret.parentComp = null;
        ret.parentState = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFrom(CircuitState src) {
        this.parentComp = src.parentComp;
        this.parentState = src.parentState;
        HashMap<CircuitState, CircuitState> substateData = new HashMap<CircuitState, CircuitState>();
        this.substates = new HashSet();
        Object object = src.dirtyLock;
        synchronized (object) {
            for (CircuitState oldSub : src.substates) {
                CircuitState newSub = new CircuitState(src.proj, oldSub.circuit, this.base);
                newSub.copyFrom(oldSub);
                newSub.parentState = this;
                this.substates.add(newSub);
                this.substatesDirty = true;
                substateData.put(oldSub, newSub);
            }
        }
        for (Component key : src.componentData.keySet()) {
            Object object2;
            Object newValue;
            Object oldValue = src.componentData.get(key);
            if (oldValue instanceof CircuitState) {
                newValue = (CircuitState)substateData.get(oldValue);
                if (newValue != null) {
                    this.componentData.put(key, newValue);
                    continue;
                }
                this.componentData.remove(key);
                continue;
            }
            if (oldValue instanceof ComponentState) {
                ComponentState state = (ComponentState)oldValue;
                object2 = state.clone();
            } else {
                object2 = oldValue;
            }
            newValue = object2;
            this.componentData.put(key, newValue);
        }
        this.slowpathValues.clear();
        object = src.valuesLock;
        synchronized (object) {
            this.slowpathValues.putAll(src.slowpathValues);
            for (int y = 0; y < 200; ++y) {
                System.arraycopy(src.fastpathValues[y], 0, this.fastpathValues[y], 0, 200);
            }
        }
        object = src.dirtyLock;
        synchronized (object) {
            this.dirtyComponents.addAll(src.dirtyComponents);
            this.dirtyPoints.addAll(src.dirtyPoints);
        }
        if (src.wireData != null) {
            this.wireData = this.circuit.wires.newState(this);
        }
    }

    public void drawOscillatingPoints(ComponentDrawContext context) {
        this.base.drawOscillatingPoints(context);
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public Object getData(Component comp) {
        return this.componentData.get(comp);
    }

    public InstanceState getInstanceState(Component comp) {
        ComponentFactory factory = comp.getFactory();
        if (factory instanceof InstanceFactory) {
            if (comp != ((InstanceComponent)comp).getInstance().getComponent()) {
                throw new IllegalStateException("instanceComponent.getInstance().getComponent() is wrong");
            }
            this.reusableInstanceState.repurpose(this, comp);
            return this.reusableInstanceState;
        }
        throw new RuntimeException("getInstanceState requires instance component");
    }

    public InstanceState getInstanceState(Instance instance) {
        InstanceFactory factory = instance.getFactory();
        if (factory instanceof InstanceFactory) {
            this.reusableInstanceState.repurpose(this, instance.getComponent());
            return this.reusableInstanceState;
        }
        throw new RuntimeException("getInstanceState() requires instance component");
    }

    public CircuitState getParentState() {
        return this.parentState;
    }

    public Project getProject() {
        return this.proj;
    }

    public Propagator getPropagator() {
        return this.base;
    }

    Component getSubcircuit() {
        return this.parentComp;
    }

    public Set<CircuitState> getSubstates() {
        return this.substates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(Location p) {
        Value value = null;
        if (p.x >= 0 && p.y >= 0 && p.x % 10 == 0 && p.y % 10 == 0 && p.x < 2000 && p.y < 2000) {
            int x = p.x / 10;
            int y = p.y / 10;
            Object object = this.valuesLock;
            synchronized (object) {
                value = this.fastpathValues[y][x];
                if (value == null) {
                    value = CircuitWires.getBusValue(this, p);
                }
            }
        }
        Object object = this.valuesLock;
        synchronized (object) {
            value = this.slowpathValues.get(p);
            if (value == null) {
                value = CircuitWires.getBusValue(this, p);
            }
        }
        return value != null ? value : Value.createUnknown(this.circuit.getWidth(p));
    }

    CircuitWires.State getWireData() {
        return this.wireData;
    }

    public boolean isSubstate() {
        return this.parentState != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAllComponentsDirty() {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirtyComponents.addAll(this.circuit.getNonWires());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markComponentAsDirty(Component comp) {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirtyComponents.add(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markComponentsDirty(Collection<Component> comps) {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirtyComponents.addAll(comps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markPointAsDirty(Propagator.SimulatorEvent ev) {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirtyPoints.add(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDirtyComponents() {
        if (!this.dirtyComponentsWorking.isEmpty()) {
            throw new IllegalStateException("INTERNAL ERROR: dirtyComponentsWorking not empty");
        }
        CircuitState[] circuitStateArray = this.dirtyLock;
        synchronized (this.dirtyLock) {
            ArrayList<Component> other = this.dirtyComponents;
            this.dirtyComponents = this.dirtyComponentsWorking;
            this.dirtyComponentsWorking = other;
            if (this.substatesDirty) {
                this.substatesDirty = false;
                this.substatesWorking = this.substates.toArray(this.substatesWorking);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                for (Component comp : this.dirtyComponentsWorking) {
                    comp.propagate(this);
                    if (!(comp.getFactory() instanceof Pin) || this.parentState == null) continue;
                    this.parentComp.propagate(this.parentState);
                }
            }
            finally {
                this.dirtyComponentsWorking.clear();
            }
            for (CircuitState substate : this.substatesWorking) {
                if (substate == null) break;
                substate.processDirtyComponents();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDirtyPoints() {
        if (!this.dirtyPointsWorking.isEmpty()) {
            throw new IllegalStateException("INTERNAL ERROR: dirtyPointsWorking not empty");
        }
        CircuitState[] circuitStateArray = this.dirtyLock;
        synchronized (this.dirtyLock) {
            ArrayList<Propagator.SimulatorEvent> other = this.dirtyPoints;
            this.dirtyPoints = this.dirtyPointsWorking;
            this.dirtyPointsWorking = other;
            if (this.substatesDirty) {
                this.substatesDirty = false;
                this.substatesWorking = this.substates.toArray(this.substatesWorking);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.circuit.wires.propagate(this, this.dirtyPointsWorking);
            this.dirtyPointsWorking.clear();
            for (CircuitState substate : this.substatesWorking) {
                if (substate == null) break;
                substate.processDirtyPoints();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.temporaryClock = null;
        this.wireData = null;
        for (Component comp : this.componentData.keySet()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (componentFactory instanceof Ram) {
                Ram ram = (Ram)componentFactory;
                boolean remove = ram.reset(this, Instance.getInstanceFor(comp));
                if (!remove) continue;
                this.componentData.put(comp, null);
                continue;
            }
            if (comp.getFactory() instanceof Buzzer) {
                Buzzer.stopBuzzerSound(comp, this);
                continue;
            }
            if (comp.getFactory() instanceof SubcircuitFactory) continue;
            Object object = this.componentData.get(comp);
            if (object instanceof ComponentDataGuiProvider) {
                ComponentDataGuiProvider guiProvider = (ComponentDataGuiProvider)object;
                guiProvider.destroy();
            }
            if ((object = this.componentData.get(comp)) instanceof TelnetServer) {
                TelnetServer telnetServer = (TelnetServer)object;
                telnetServer.deleteAll();
            }
            this.componentData.put(comp, null);
        }
        Object object = this.valuesLock;
        synchronized (object) {
            this.slowpathValues.clear();
            this.clearFastpathGrid();
        }
        object = this.dirtyLock;
        synchronized (object) {
            this.dirtyComponents.clear();
            this.dirtyPoints.clear();
            for (CircuitState sub : this.substates) {
                sub.reset();
            }
        }
        this.markAllComponentsDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircuitState createCircuitSubstateFor(Component comp, Circuit circ) {
        CircuitState oldState = (CircuitState)this.componentData.get(comp);
        if (oldState != null && oldState.parentComp == comp) {
            System.out.println("fixme: removed stale circuitstate... should never happen");
            Object object = this.dirtyLock;
            synchronized (object) {
                this.substates.remove(oldState);
                this.substatesDirty = true;
            }
            oldState.parentState = null;
            oldState.parentComp = null;
        }
        CircuitState newState = new CircuitState(this.proj, circ, this.base);
        Object object = this.dirtyLock;
        synchronized (object) {
            this.substates.add(newState);
            this.substatesDirty = true;
        }
        newState.parentState = this;
        newState.parentComp = comp;
        this.componentData.put(comp, newState);
        return newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceData(Component comp, Object data) {
        if (data instanceof CircuitState) {
            CircuitState sub = (CircuitState)data;
            sub.parentComp = comp;
            CircuitState old = (CircuitState)this.componentData.put(comp, data);
            Object object = this.dirtyLock;
            synchronized (object) {
                if (old != null) {
                    this.substates.remove(old);
                    old.parentState = null;
                }
                sub.parentState = this;
                this.substates.add(sub);
                this.substatesDirty = true;
                this.dirtyComponents.add(comp);
            }
        } else {
            this.componentData.put(comp, data);
        }
    }

    public void setData(Component comp, Object data) {
        if (data instanceof CircuitState) {
            System.out.println("fixme: setData with circuitstate... should never happen");
            Thread.dumpStack();
            ((CircuitState)data).parentComp = comp;
        }
        this.componentData.put(comp, data);
    }

    public void setValue(Location pt, Value val, Component cause, int delay) {
        this.base.setValue(this, pt, val, cause, delay);
    }

    private void clearFastpathGrid() {
        for (int y = 0; y < 200; ++y) {
            for (int x = 0; x < 200; ++x) {
                this.fastpathValues[y][x] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValueByWire(Value v, Location[] points, CircuitWires.BusConnection[] connections) {
        for (Location p : points) {
            Object object;
            if (p.x >= 0 && p.y >= 0 && p.x % 10 == 0 && p.y % 10 == 0 && p.x < 2000 && p.y < 2000) {
                object = this.valuesLock;
                synchronized (object) {
                    this.fastpath(p, v);
                }
            }
            object = this.valuesLock;
            synchronized (object) {
                this.slowpath(p, v);
            }
            this.base.locationTouched(this, p);
        }
        for (CircuitWires.BusConnection bc : connections) {
            if (!bc.isSink && (!bc.isBidirectional || Value.equal(v, bc.drivenValue))) continue;
            this.markComponentAsDirty(bc.component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearValuesByWire() {
        Object object = this.valuesLock;
        synchronized (object) {
            this.slowpathValues.clear();
            this.clearFastpathGrid();
        }
    }

    private boolean fastpath(Location p, Value v) {
        int x = p.x / 10;
        int y = p.y / 10;
        if (v == Value.NIL) {
            if (this.fastpathValues[y][x] != null) {
                this.fastpathValues[y][x] = null;
                return true;
            }
            return false;
        }
        if (!v.equals(this.fastpathValues[y][x])) {
            this.fastpathValues[y][x] = v;
            return true;
        }
        return false;
    }

    private boolean slowpath(Location p, Value v) {
        if (v == Value.NIL) {
            Value old = this.slowpathValues.remove(p);
            return old != null && old != Value.NIL;
        }
        Value old = this.slowpathValues.put(p, v);
        return !v.equals(old);
    }

    void setWireData(CircuitWires.State data) {
        this.wireData = data;
    }

    private void markDirtyComponents(Location p, Component[] affected) {
        for (Component comp : affected) {
            this.markComponentAsDirty(comp);
        }
        if (affected.length > 0) {
            this.base.locationTouched(this, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean toggleClocks(int ticks) {
        boolean hasClocks = false;
        if (this.temporaryClock != null) {
            hasClocks |= this.temporaryClockValidateOrTick(ticks);
        }
        for (Component clock : this.circuit.getClocks()) {
            hasClocks = true;
            boolean dirty = Clock.tick(this, ticks, clock);
            if (!dirty) continue;
            this.markComponentAsDirty(clock);
            this.proj.getSimulator().addPendingInput(this, clock);
        }
        CircuitState[] circuitStateArray = this.dirtyLock;
        synchronized (circuitStateArray) {
            if (this.substatesDirty) {
                this.substatesDirty = false;
                this.substatesWorking = this.substates.toArray(this.substatesWorking);
            }
        }
        for (CircuitState substate : this.substatesWorking) {
            if (substate == null) break;
            hasClocks |= substate.toggleClocks(ticks);
        }
        return hasClocks;
    }

    private boolean temporaryClockValidateOrTick(int ticks) {
        try {
            Pin pin = (Pin)this.temporaryClock.getFactory();
            Instance instance = Instance.getInstanceFor(this.temporaryClock);
            if (instance == null || !pin.isInputPin(instance) || pin.getWidth(instance).getWidth() != 1) {
                this.temporaryClock = null;
                return false;
            }
            if (ticks >= 0) {
                Value vNew;
                InstanceState state = this.getInstanceState(instance);
                Value vOld = pin.getValue(state);
                Value value = vNew = ticks % 2 == 0 ? Value.FALSE : Value.TRUE;
                if (!vNew.equals(vOld)) {
                    pin.driveInputPin(state, vNew);
                    this.markComponentAsDirty(this.temporaryClock);
                    this.proj.getSimulator().addPendingInput(this, this.temporaryClock);
                }
            }
            return true;
        }
        catch (ClassCastException e) {
            this.temporaryClock = null;
            return false;
        }
    }

    public boolean hasKnownClocks() {
        return this.knownClocks || this.temporaryClock != null;
    }

    public void markKnownClocks() {
        this.knownClocks = true;
    }

    public boolean setTemporaryClock(Component clk) {
        this.temporaryClock = clk;
        return clk == null || this.temporaryClockValidateOrTick(-1);
    }

    public Component getTemporaryClock() {
        return this.temporaryClock;
    }

    public String toString() {
        return "State" + this.id + "[" + this.circuit.getName() + "]";
    }

    private class MyCircuitListener
    implements CircuitListener {
        private MyCircuitListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void circuitChanged(CircuitEvent event) {
            int action = event.getAction();
            if (action != 1) {
                if (action == 2) {
                    Component comp = (Component)event.getData();
                    if (comp == CircuitState.this.temporaryClock) {
                        CircuitState.this.temporaryClock = null;
                    }
                    if (comp.getFactory() instanceof Clock) {
                        CircuitState.this.knownClocks = false;
                    }
                    if (comp.getFactory() instanceof SubcircuitFactory) {
                        CircuitState.this.knownClocks = false;
                        CircuitState circuitState = (CircuitState)CircuitState.this.getData(comp);
                        if (circuitState != null && circuitState.parentComp == comp) {
                            Object object = CircuitState.this.dirtyLock;
                            synchronized (object) {
                                CircuitState.this.substates.remove(circuitState);
                                CircuitState.this.substatesDirty = true;
                            }
                            circuitState.parentState = null;
                            circuitState.parentComp = null;
                            circuitState.reset();
                        }
                    } else {
                        Object object = CircuitState.this.getData(comp);
                        if (object instanceof ComponentDataGuiProvider) {
                            ComponentDataGuiProvider guiProvider = (ComponentDataGuiProvider)object;
                            guiProvider.destroy();
                        }
                    }
                    if (comp instanceof Wire) {
                        Wire w = (Wire)comp;
                    } else {
                        Object object = CircuitState.this.dirtyLock;
                        synchronized (object) {
                            while (CircuitState.this.dirtyComponents.remove(comp)) {
                            }
                        }
                    }
                } else {
                    if (action == 5) {
                        CircuitState.this.temporaryClock = null;
                        CircuitState.this.knownClocks = false;
                        CircuitState.this.wireData = null;
                        for (Component comp : CircuitState.this.componentData.keySet()) {
                            Object object = CircuitState.this.componentData.get(comp);
                            if (object instanceof ComponentDataGuiProvider) {
                                ComponentDataGuiProvider componentDataGuiProvider = (ComponentDataGuiProvider)object;
                                componentDataGuiProvider.destroy();
                                continue;
                            }
                            object = CircuitState.this.componentData.get(comp);
                            if (!(object instanceof CircuitState)) continue;
                            CircuitState circuitState = (CircuitState)object;
                            circuitState.reset();
                        }
                        CircuitState.this.componentData.clear();
                        Object comp = CircuitState.this.valuesLock;
                        synchronized (comp) {
                            CircuitState.this.slowpathValues.clear();
                            CircuitState.this.clearFastpathGrid();
                        }
                        comp = CircuitState.this.dirtyLock;
                        synchronized (comp) {
                            CircuitState.this.dirtyComponents.clear();
                            CircuitState.this.dirtyPoints.clear();
                            CircuitState.this.substates.clear();
                            CircuitState.this.substatesWorking = new CircuitState[0];
                            CircuitState.this.substatesDirty = true;
                        }
                    }
                    if (action == 4) {
                        Component comp = (Component)event.getData();
                        CircuitState.this.markComponentAsDirty(comp);
                        CircuitState.this.proj.getSimulator().addPendingInput(CircuitState.this, comp);
                    } else if (action == 6) {
                        ReplacementMap map = event.getResult().getReplacementMap(CircuitState.this.circuit);
                        if (map == null) {
                            return;
                        }
                        for (Component component : map.getRemovals()) {
                            Object compState = CircuitState.this.componentData.remove(component);
                            if (compState != null) continue;
                            Class<?> compFactory = component.getFactory().getClass();
                            boolean found = false;
                            for (Component repl : map.getReplacementsFor(component)) {
                                if (repl.getFactory().getClass() != compFactory) continue;
                                found = true;
                                CircuitState.this.replaceData(repl, compState);
                                break;
                            }
                            if (!found && compState instanceof RamState) {
                                RamState state = (RamState)compState;
                                Ram.closeHexFrame(state);
                            }
                            if (found || !(compState instanceof CircuitState)) continue;
                            CircuitState sub = (CircuitState)compState;
                            sub.parentState = null;
                            Object object = CircuitState.this.dirtyLock;
                            synchronized (object) {
                                CircuitState.this.substates.remove(sub);
                                CircuitState.this.substatesDirty = true;
                            }
                        }
                    }
                }
            }
        }
    }
}

