/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.model.Expression;

public class Expressions {
    private Expressions() {
    }

    public static Expression and(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new And(a, b);
    }

    public static Expression constant(int value) {
        return new Constant(value);
    }

    public static Expression not(Expression a) {
        if (a == null) {
            return null;
        }
        return new Not(a);
    }

    public static Expression or(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Or(a, b);
    }

    public static Expression xor(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Xor(a, b);
    }

    public static Expression xnor(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Xnor(a, b);
    }

    public static Expression eq(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Eq(a, b);
    }

    public static Expression variable(String name) {
        return new Variable(name);
    }

    private static class And
    extends Binary {
        And(Expression a, Expression b) {
            super(a, b);
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.AND.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.AND;
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitAnd(this.exprA, this.exprB);
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitAnd(this.exprA, this.exprB);
        }
    }

    private static class Constant
    extends Expression {
        private final int value;

        Constant(int value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof Constant) {
                Constant o = (Constant)other;
                bl = this.value == o.value;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return Integer.MAX_VALUE;
        }

        @Override
        public Expression.Op getOp() {
            return null;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitConstant(this.value);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitConstant(this.value);
        }
    }

    private static class Not
    extends Expression {
        private final Expression expr;

        Not(Expression a) {
            this.expr = a;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof Not) {
                Not o = (Not)other;
                bl = this.expr.equals(o.expr);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.NOT.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.NOT;
        }

        public int hashCode() {
            return 31 * this.expr.hashCode();
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitNot(this.expr);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitNot(this.expr);
        }
    }

    private static class Or
    extends Binary {
        Or(Expression a, Expression b) {
            super(a, b);
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.OR.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.OR;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitOr(this.exprA, this.exprB);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitOr(this.exprA, this.exprB);
        }
    }

    private static class Xor
    extends Binary {
        Xor(Expression a, Expression b) {
            super(a, b);
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.XOR.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.XOR;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitXor(this.exprA, this.exprB);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitXor(this.exprA, this.exprB);
        }
    }

    private static class Xnor
    extends Binary {
        Xnor(Expression a, Expression b) {
            super(a, b);
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.XNOR.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.XNOR;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitXnor(this.exprA, this.exprB);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitXnor(this.exprA, this.exprB);
        }
    }

    protected static class Eq
    extends Binary {
        Eq(Expression a, Expression b) {
            super(a, b);
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return notation.opLvl[Expression.Op.EQ.id];
        }

        @Override
        public Expression.Op getOp() {
            return Expression.Op.EQ;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitEq(this.exprA, this.exprB);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitEq(this.exprA, this.exprB);
        }
    }

    protected static class Variable
    extends Expression {
        private final String name;

        Variable(String name) {
            this.name = name;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof Variable) {
                Variable o = (Variable)other;
                bl = this.name.equals(o.name);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public int getPrecedence(Expression.Notation notation) {
            return Integer.MAX_VALUE;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public Expression.Op getOp() {
            return null;
        }

        @Override
        public <T> T visit(Expression.Visitor<T> visitor) {
            return visitor.visitVariable(this.name);
        }

        @Override
        int visit(Expression.IntVisitor visitor) {
            return visitor.visitVariable(this.name);
        }
    }

    private static abstract class Binary
    extends Expression {
        protected final Expression exprA;
        protected final Expression exprB;

        Binary(Expression a, Expression b) {
            this.exprA = a;
            this.exprB = b;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            Binary o = (Binary)other;
            return this.exprA.equals(o.exprA) && this.exprB.equals(o.exprB);
        }

        public int hashCode() {
            return 31 * (31 * this.getClass().hashCode() + this.exprA.hashCode()) + this.exprB.hashCode();
        }
    }
}

