/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.TableTab;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.gui.generic.OptionPane;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;

class TableTabClip
implements ClipboardOwner {
    private static final DataFlavor binaryFlavor = new DataFlavor(Data.class, "Binary data");
    private final TableTab table;

    TableTabClip(TableTab table) {
        this.table = table;
    }

    public boolean canPaste() {
        Clipboard clip = this.table.getToolkit().getSystemClipboard();
        Transferable xfer = clip.getContents(this);
        return xfer.isDataFlavorSupported(binaryFlavor);
    }

    public void copy() {
        Rectangle s = this.table.getCaret().getSelection();
        if (s.width <= 0 || s.height <= 0) {
            return;
        }
        TruthTable t = this.table.getTruthTable();
        int inputs = t.getInputColumnCount();
        String[] header = new String[s.width];
        for (int c = s.x; c < s.x + s.width; ++c) {
            header[c - s.x] = c < inputs ? t.getInputHeader(c) : t.getOutputHeader(c - inputs);
        }
        String[][] contents = new String[s.height][s.width];
        for (int r = s.y; r < s.y + s.height; ++r) {
            for (int c = s.x; c < s.x + s.width; ++c) {
                contents[r - s.y][c - s.x] = c < inputs ? t.getInputEntry(r, c).getDescription() : t.getOutputEntry(r, c - inputs).getDescription();
            }
        }
        Clipboard clip = this.table.getToolkit().getSystemClipboard();
        clip.setContents(new Data(header, contents), this);
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable transfer) {
    }

    public void paste() {
        Entry[][] entries;
        Transferable xfer;
        Clipboard clip = this.table.getToolkit().getSystemClipboard();
        try {
            xfer = clip.getContents(this);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException t) {
            OptionPane.showMessageDialog(this.table.getRootPane(), Strings.S.get("clipPasteSupportedError"), Strings.S.get("clipPasteErrorTitle"), 0);
            return;
        }
        if (xfer.isDataFlavorSupported(binaryFlavor)) {
            try {
                Data data = (Data)xfer.getTransferData(binaryFlavor);
                entries = new Entry[data.contents.length][];
                for (int i = 0; i < entries.length; ++i) {
                    Entry[] row = new Entry[data.contents[i].length];
                    for (int j = 0; j < row.length; ++j) {
                        row[j] = Entry.parse(data.contents[i][j]);
                    }
                    entries[i] = row;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return;
            }
        } else if (xfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String buf = (String)xfer.getTransferData(DataFlavor.stringFlavor);
                StringTokenizer lines = new StringTokenizer(buf, "\r\n");
                if (!lines.hasMoreTokens()) {
                    return;
                }
                String first = lines.nextToken();
                StringTokenizer toks = new StringTokenizer(first, "\t,");
                String[] headers = new String[toks.countTokens()];
                Entry[] firstEntries = new Entry[headers.length];
                boolean allParsed = true;
                int i = 0;
                while (toks.hasMoreTokens()) {
                    headers[i] = toks.nextToken();
                    firstEntries[i] = Entry.parse(headers[i]);
                    allParsed = allParsed && firstEntries[i] != null;
                    ++i;
                }
                int rows = lines.countTokens();
                if (allParsed) {
                    ++rows;
                }
                entries = new Entry[rows][];
                int cur = 0;
                if (allParsed) {
                    entries[0] = firstEntries;
                    ++cur;
                }
                while (lines.hasMoreTokens()) {
                    toks = new StringTokenizer(lines.nextToken(), "\t");
                    Entry[] ents = new Entry[toks.countTokens()];
                    int i2 = 0;
                    while (toks.hasMoreTokens()) {
                        ents[i2] = Entry.parse(toks.nextToken());
                        ++i2;
                    }
                    entries[cur] = ents;
                    ++cur;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return;
            }
        } else {
            OptionPane.showMessageDialog(this.table.getRootPane(), Strings.S.get("clipPasteSupportedError"), Strings.S.get("clipPasteErrorTitle"), 0);
            return;
        }
        Rectangle s = this.table.getCaret().getSelection();
        if (s.width <= 0 || s.height <= 0) {
            return;
        }
        TruthTable model = this.table.getTruthTable();
        int rows = model.getVisibleRowCount();
        int inputs = model.getInputColumnCount();
        int outputs = model.getOutputColumnCount();
        if (s.width == 1 && s.height == 1) {
            if (s.y + entries.length > rows || s.x + entries[0].length > inputs + outputs) {
                OptionPane.showMessageDialog(this.table.getRootPane(), Strings.S.get("clipPasteEndError"), Strings.S.get("clipPasteErrorTitle"), 0);
                return;
            }
        } else if (s.height != entries.length || s.width != entries[0].length) {
            OptionPane.showMessageDialog(this.table.getRootPane(), Strings.S.get("clipPasteSizeError"), Strings.S.get("clipPasteErrorTitle"), 0);
            return;
        }
        for (int r = 0; r < entries.length; ++r) {
            for (int c = 0; c < entries[0].length; ++c) {
                if (s.x + c < inputs) continue;
                model.setVisibleOutputEntry(s.y + r, s.x + c - inputs, entries[r][c]);
            }
        }
    }

    private static class Data
    implements Transferable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String[] headers;
        private final String[][] contents;

        Data(String[] headers, String[][] contents) {
            this.headers = headers;
            this.contents = contents;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor == binaryFlavor) {
                return this;
            }
            if (flavor == DataFlavor.stringFlavor) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.headers.length; ++i) {
                    buf.append(this.headers[i]);
                    buf.append(i == this.headers.length - 1 ? (char)'\n' : '\t');
                }
                for (String[] content : this.contents) {
                    for (int j = 0; j < content.length; ++j) {
                        buf.append(content[j]);
                        buf.append(j == content.length - 1 ? (char)'\n' : '\t');
                    }
                }
                return buf.toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{binaryFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == binaryFlavor || flavor == DataFlavor.stringFlavor;
        }
    }
}

