/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.data;

import com.cburch.logisim.analyze.data.CoverColor;
import com.cburch.logisim.analyze.gui.KarnaughMapPanel;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Implicant;
import com.cburch.logisim.analyze.model.TruthTable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class KarnaughMapGroups {
    private final AnalyzerModel model;
    private String output;
    private int format;
    private ArrayList<KMapGroupInfo> covers;
    private static final int IMP_RADIUS = 5;
    private static final int IMP_INSET = 4;
    private int highlighted;

    public KarnaughMapGroups(AnalyzerModel model) {
        this.model = model;
        this.highlighted = -1;
    }

    public void setformat(int format) {
        this.format = format;
        this.update();
    }

    public List<KMapGroupInfo> getCovers() {
        return this.covers;
    }

    public void setOutput(String name) {
        this.output = name;
        this.update();
    }

    public boolean highlight(int col, int row) {
        int oldHighlighted = this.highlighted;
        this.highlighted = -1;
        for (int nr = 0; nr < this.covers.size() && this.highlighted < 0; ++nr) {
            if (!this.covers.get(nr).insideCover(col, row)) continue;
            this.highlighted = nr;
        }
        return oldHighlighted != this.highlighted;
    }

    public boolean clearHighlight() {
        boolean ret = this.highlighted >= 0;
        this.highlighted = -1;
        return ret;
    }

    public Expression getHighlightedExpression() {
        if (this.highlighted < 0 || this.highlighted >= this.covers.size()) {
            return null;
        }
        return this.covers.get((int)this.highlighted).expression;
    }

    public Color getBackgroundColor() {
        if (this.highlighted < 0 || this.highlighted >= this.covers.size()) {
            return null;
        }
        Color col = this.covers.get((int)this.highlighted).color;
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), 60);
    }

    public void update() {
        List<Implicant> implicants = this.model.getOutputExpressions().getMinimalImplicants(this.output);
        this.covers = new ArrayList();
        CoverColor.COVER_COLOR.reset();
        if (implicants != null) {
            for (Implicant imp : implicants) {
                this.covers.add(new KMapGroupInfo(imp, CoverColor.COVER_COLOR.getNext()));
            }
        }
        this.highlighted = -1;
    }

    public void paint(Graphics2D g, int x, int y, int cellWidth, int cellHeight) {
        for (int cov = 0; cov < this.covers.size(); ++cov) {
            if (cov == this.highlighted) continue;
            KMapGroupInfo curCov = this.covers.get(cov);
            curCov.paint(g, x, y, cellWidth, cellHeight, false, this.highlighted < 0);
        }
        if (this.highlighted >= 0 && this.highlighted < this.covers.size()) {
            this.covers.get(this.highlighted).paint(g, x, y, cellWidth, cellHeight, true, true);
        }
    }

    public class KMapGroupInfo {
        private final ArrayList<CoverInfo> areas;
        private final Color color;
        private final ArrayList<Implicant> singleCoveredImplicants;
        private final Expression expression;

        public KMapGroupInfo(Implicant imp, Color col) {
            this.color = col;
            this.areas = new ArrayList();
            this.singleCoveredImplicants = new ArrayList();
            ArrayList<Implicant> one = new ArrayList<Implicant>();
            one.add(imp);
            this.expression = Implicant.toExpression(KarnaughMapGroups.this.format, KarnaughMapGroups.this.model, one);
            this.build(imp);
        }

        public List<CoverInfo> getAreas() {
            return this.areas;
        }

        public Color getColor() {
            return this.color;
        }

        public void removeSingleCover(Implicant imp) {
            this.singleCoveredImplicants.remove(imp);
        }

        public boolean containsSingleCover(Implicant imp) {
            return this.singleCoveredImplicants.contains(imp);
        }

        public void paint(Graphics2D g, int x, int y, int cellWidth, int cellHeight, boolean highlighted, boolean colored) {
            int d = 10;
            Color col = g.getColor();
            if (highlighted) {
                g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 180));
            } else if (colored) {
                g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 128));
            } else {
                g.setColor(new Color(128, 128, 128, 128));
            }
            for (CoverInfo cover : this.areas) {
                g.fillRoundRect(x + cover.getCol() * cellWidth + 4, y + cover.getRow() * cellHeight + 4, cover.getWidth() * cellWidth - 8, cover.getHeight() * cellHeight - 8, d, d);
            }
            g.setColor(col);
        }

        public boolean insideCover(int col, int row) {
            TruthTable table = KarnaughMapGroups.this.model.getTruthTable();
            if (table.getInputColumnCount() > 6) {
                return false;
            }
            int kmapRows = 1 << KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()];
            int kmapCols = 1 << KarnaughMapPanel.COL_VARS[table.getInputColumnCount()];
            for (Implicant sq : this.singleCoveredImplicants) {
                int tableRow = sq.getRow();
                if (tableRow < 0) {
                    return false;
                }
                int krow = KarnaughMapPanel.getRow(tableRow, kmapRows, kmapCols);
                int kcol = KarnaughMapPanel.getCol(tableRow, kmapRows, kmapCols);
                if (krow != row || kcol != col) continue;
                return true;
            }
            return false;
        }

        private void addSingleCover(Implicant imp) {
            for (KMapGroupInfo other : KarnaughMapGroups.this.covers) {
                if (!other.containsSingleCover(imp)) continue;
                other.removeSingleCover(imp);
            }
            this.singleCoveredImplicants.add(imp);
        }

        private void build(Implicant imp) {
            TruthTable table = KarnaughMapGroups.this.model.getTruthTable();
            if (table.getInputColumnCount() > 6) {
                return;
            }
            int kmapRows = 1 << KarnaughMapPanel.ROW_VARS[table.getInputColumnCount()];
            int kmapCols = 1 << KarnaughMapPanel.COL_VARS[table.getInputColumnCount()];
            Boolean[][] imps = new Boolean[kmapRows][kmapCols];
            for (int row = 0; row < kmapRows; ++row) {
                for (int col = 0; col < kmapCols; ++col) {
                    imps[row][col] = false;
                }
            }
            for (Implicant sq : imp.getTerms()) {
                this.addSingleCover(sq);
                int tableRow = sq.getRow();
                if (tableRow < 0) {
                    return;
                }
                int row = KarnaughMapPanel.getRow(tableRow, kmapRows, kmapCols);
                int col = KarnaughMapPanel.getCol(tableRow, kmapRows, kmapCols);
                if (row >= kmapRows || col >= kmapCols) continue;
                imps[row][col] = true;
            }
            CoverInfo current = null;
            for (int row = 0; row < kmapRows; ++row) {
                for (int col = 0; col < kmapCols; ++col) {
                    if (imps[row][col].booleanValue()) {
                        if (current != null) {
                            if (current.merge(col, row)) continue;
                            if (!this.areas.contains(current)) {
                                this.areas.add(current);
                            }
                        }
                        boolean found = false;
                        for (CoverInfo area : this.areas) {
                            if (found || !area.merge(col, row)) continue;
                            current = area;
                            found = true;
                        }
                        if (found) continue;
                        current = new CoverInfo(col, row);
                        continue;
                    }
                    if (current != null && !this.areas.contains(current)) {
                        this.areas.add(current);
                    }
                    current = null;
                }
            }
            if (current != null && !this.areas.contains(current)) {
                this.areas.add(current);
            }
        }
    }

    public static class CoverInfo {
        private final int startRow;
        private final int startCol;
        private int width;
        private int height;

        public CoverInfo(int col, int row) {
            this.startRow = row;
            this.startCol = col;
            this.width = 1;
            this.height = 1;
        }

        public int getCol() {
            return this.startCol;
        }

        public int getRow() {
            return this.startRow;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        private boolean canMerge(int col, int row) {
            if (col >= this.startCol && col < this.startCol + this.width) {
                if (row >= this.startRow && row < this.startRow + this.height) {
                    return true;
                }
                return row >= this.startRow && row <= this.startRow + this.height;
            }
            if (row >= this.startRow && row < this.startRow + this.height) {
                return col >= this.startCol && col <= this.startCol + this.width;
            }
            return false;
        }

        public boolean merge(int col, int row) {
            if (!this.canMerge(col, row)) {
                return false;
            }
            if (col >= this.startCol && col < this.startCol + this.width) {
                if (row >= this.startRow && row < this.startRow + this.height) {
                    return true;
                }
                ++this.height;
            } else {
                ++this.width;
            }
            return true;
        }
    }
}

