/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.data;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.Range;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;

public class ExpressionRenderData {
    private final Expression expr;
    private final Expression.Notation notation;
    private final int prefWidth;
    private final int parentWidth;
    private int height;
    private String[] lineText;
    private final ArrayList<ArrayList<Range>> lineNots;
    private final ArrayList<ArrayList<Range>> lineSubscripts;
    private ArrayList<ArrayList<Range>> lineMarks;
    private int[] lineY;
    private AttributedString[] lineStyled;
    private int[][] notStarts;
    private int[][] notStops;
    private static final Color MARKCOLOR = Color.BLACK;
    private final Font expressionBaseFont;
    private final FontMetrics expressionBaseFontMetrics;
    private final int notSep;
    private final int extraLeading;
    private final int minimumHeight;

    public ExpressionRenderData(Expression expr, int width, Expression.Notation notation) {
        this.expr = expr;
        this.parentWidth = width;
        this.notation = notation;
        this.notSep = AppPreferences.getScaled(3);
        this.extraLeading = AppPreferences.getScaled(4);
        this.expressionBaseFont = AppPreferences.getScaledFont(new Font("Monospaced", 0, 14));
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g = (Graphics2D)img.getGraphics().create();
        if (AppPreferences.AntiAliassing.getBoolean()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.expressionBaseFont);
        FontMetrics fm = this.expressionBaseFontMetrics = g.getFontMetrics();
        this.minimumHeight = fm.getHeight() + fm.getHeight() >> 1;
        g.dispose();
        if (expr == null || expr.toString(notation, true).length() == 0) {
            this.lineStyled = null;
            this.lineText = new String[]{Strings.S.get("expressionEmpty")};
            this.lineSubscripts = new ArrayList();
            this.lineSubscripts.add(new ArrayList());
            this.lineNots = new ArrayList();
            this.lineNots.add(new ArrayList());
            this.lineMarks = new ArrayList();
            this.lineMarks.add(new ArrayList());
        } else {
            this.computeLineText();
            this.lineSubscripts = this.computeLineAttribs(expr.subscripts);
            this.lineNots = this.computeLineAttribs(expr.nots);
            this.lineMarks = this.computeLineAttribs(expr.marks);
            this.computeNotDepths();
        }
        this.computeLineY();
        this.prefWidth = this.lineText.length > 1 ? width : fm.stringWidth(this.lineText[0]);
    }

    public void setSubExpression(Expression subExpr) {
        if (this.expr == null || subExpr == null) {
            return;
        }
        this.expr.toString(this.notation, true, subExpr);
        this.lineMarks = this.computeLineAttribs(this.expr.marks);
        this.lineStyled = null;
    }

    private ArrayList<ArrayList<Range>> computeLineAttribs(List<Range> attribs) {
        ArrayList<ArrayList<Range>> attrs = new ArrayList<ArrayList<Range>>();
        for (int i = 0; i < this.lineText.length; ++i) {
            attrs.add(new ArrayList());
        }
        for (Range nd : attribs) {
            int pos = 0;
            for (int j = 0; j < attrs.size() && pos < nd.stopIndex; ++j) {
                String line = this.lineText[j];
                int nextPos = pos + line.length();
                if (nextPos > nd.startIndex) {
                    Range toAdd = new Range();
                    toAdd.startIndex = Math.max(pos, nd.startIndex) - pos;
                    toAdd.stopIndex = Math.min(nextPos, nd.stopIndex) - pos;
                    attrs.get(j).add(toAdd);
                }
                pos = nextPos;
            }
        }
        return attrs;
    }

    public int getParentWidth() {
        return this.parentWidth;
    }

    private void computeLineText() {
        String addedLine;
        int i;
        String text = this.expr.toString(this.notation, true);
        Integer[] badness = this.expr.getBadness();
        ArrayList<Integer> bestBreakPositions = new ArrayList<Integer>();
        ArrayList<Integer> secondBestBreakPositions = new ArrayList<Integer>();
        int minimal1 = Integer.MAX_VALUE;
        int minimal2 = Integer.MAX_VALUE;
        this.lineStyled = null;
        for (i = 0; i < text.length(); ++i) {
            if (badness[i] < minimal1) {
                minimal1 = badness[i];
                continue;
            }
            if (badness[i] >= minimal2 || badness[i] <= minimal1) continue;
            minimal2 = badness[i];
        }
        for (i = 0; i < text.length(); ++i) {
            if (badness[i] == minimal1) {
                bestBreakPositions.add(i + 1);
                secondBestBreakPositions.add(i + 1);
                continue;
            }
            if (badness[i] != minimal2) continue;
            secondBestBreakPositions.add(i + 1);
        }
        bestBreakPositions.add(text.length());
        secondBestBreakPositions.add(text.length());
        ArrayList<String> lines = new ArrayList<String>();
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g = (Graphics2D)img.getGraphics().create();
        if (AppPreferences.AntiAliassing.getBoolean()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.expressionBaseFont);
        FontRenderContext ctx = g.getFontRenderContext();
        int i2 = bestBreakPositions.size() - 1;
        int breakPosition = 0;
        while (i2 >= 0 && text.length() > 0 && (Integer)bestBreakPositions.get(i2) - breakPosition > 0) {
            if (this.getWidth(ctx, text, (Integer)bestBreakPositions.get(i2) - breakPosition, this.expr.subscripts, this.expr.marks) <= this.parentWidth) {
                addedLine = text.substring(0, (Integer)bestBreakPositions.get(i2) - breakPosition);
                lines.add(addedLine);
                text = text.substring((Integer)bestBreakPositions.get(i2) - breakPosition);
                breakPosition += addedLine.length();
                i2 = bestBreakPositions.size() - 1;
                continue;
            }
            --i2;
        }
        i2 = secondBestBreakPositions.size() - 1;
        while (i2 >= 0 && text.length() > 0 && (Integer)secondBestBreakPositions.get(i2) - breakPosition > 0) {
            if (this.getWidth(ctx, text, (Integer)secondBestBreakPositions.get(i2) - breakPosition, this.expr.subscripts, this.expr.marks) <= this.parentWidth || i2 == 0 || (Integer)secondBestBreakPositions.get(i2 - 1) - breakPosition <= 0) {
                addedLine = text.substring(0, (Integer)secondBestBreakPositions.get(i2) - breakPosition);
                lines.add(addedLine);
                text = text.substring((Integer)secondBestBreakPositions.get(i2) - breakPosition);
                breakPosition += addedLine.length();
                i2 = secondBestBreakPositions.size() - 1;
                continue;
            }
            --i2;
        }
        g.dispose();
        this.lineText = lines.toArray(new String[0]);
    }

    private void computeLineY() {
        this.lineY = new int[this.lineNots.size()];
        int curY = 0;
        for (int i = 0; i < this.lineY.length; ++i) {
            int maxDepth = -1;
            ArrayList<Range> nots = this.lineNots.get(i);
            for (Range nd : nots) {
                if (nd.depth <= maxDepth) continue;
                maxDepth = nd.depth;
            }
            this.lineY[i] = curY + (maxDepth + 1) * AppPreferences.getScaled(this.notSep);
            curY = this.lineY[i] + this.expressionBaseFontMetrics.getHeight() + this.extraLeading;
        }
        this.height = Math.max(this.minimumHeight, curY);
    }

    private void computeNotDepths() {
        for (ArrayList<Range> nots : this.lineNots) {
            int n = nots.size();
            int[] stack = new int[n];
            for (int i = 0; i < nots.size(); ++i) {
                Range nd = nots.get(i);
                int depth = 0;
                int top = 0;
                stack[0] = nd.stopIndex;
                for (int j = i + 1; j < nots.size(); ++j) {
                    Range nd2 = nots.get(j);
                    if (nd2.startIndex >= nd.stopIndex) break;
                    while (nd2.startIndex >= stack[top]) {
                        --top;
                    }
                    stack[++top] = nd2.stopIndex;
                    if (top <= depth) continue;
                    depth = top;
                }
                nd.depth = depth;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth, this.height);
    }

    private AttributedString style(String s, int end, List<Range> subs, List<Range> marks, boolean replaceSpaces) {
        String sub = s.substring(0, end);
        if (replaceSpaces) {
            sub = sub.replace(" ", "_");
        }
        AttributedString as = new AttributedString(sub);
        as.addAttribute(TextAttribute.FAMILY, this.expressionBaseFont.getFamily());
        as.addAttribute(TextAttribute.SIZE, this.expressionBaseFont.getSize());
        for (Range r : subs) {
            if (r.stopIndex > end) continue;
            as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, r.startIndex, r.stopIndex);
        }
        for (Range m : marks) {
            if (m.stopIndex > end) continue;
            as.addAttribute(TextAttribute.FOREGROUND, MARKCOLOR, m.startIndex, m.stopIndex);
        }
        return as;
    }

    public int getWidth() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g = (Graphics2D)img.getGraphics().create();
        g.setFont(this.expressionBaseFont);
        if (AppPreferences.AntiAliassing.getBoolean()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FontRenderContext ctx = g.getFontRenderContext();
        if (this.lineStyled == null) {
            this.lineStyled = new AttributedString[this.lineText.length];
            this.notStarts = new int[this.lineText.length][];
            this.notStops = new int[this.lineText.length][];
            for (int i = 0; i < this.lineText.length; ++i) {
                String line = this.lineText[i];
                ArrayList<Range> nots = this.lineNots.get(i);
                ArrayList<Range> subs = this.lineSubscripts.get(i);
                ArrayList<Range> marks = this.lineMarks.get(i);
                this.notStarts[i] = new int[nots.size()];
                this.notStops[i] = new int[nots.size()];
                for (int j = 0; j < nots.size(); ++j) {
                    Range not = nots.get(j);
                    this.notStarts[i][j] = this.getWidth(ctx, line, not.startIndex, subs, marks);
                    this.notStops[i][j] = this.getWidth(ctx, line, not.stopIndex, subs, marks);
                }
                this.lineStyled[i] = this.style(line, line.length(), subs, marks, false);
            }
        }
        int width = 0;
        for (AttributedString attributedString : this.lineStyled) {
            TextLayout test = new TextLayout(attributedString.getIterator(), ctx);
            if (!(test.getBounds().getWidth() > (double)width)) continue;
            width = (int)test.getBounds().getWidth();
        }
        g.dispose();
        return width;
    }

    private int getWidth(FontRenderContext ctx, String s, int end, List<Range> subs, List<Range> marks) {
        if (end == 0) {
            return 0;
        }
        AttributedString as = this.style(s, end, subs, marks, true);
        TextLayout layout = new TextLayout(as.getIterator(), ctx);
        return (int)layout.getBounds().getWidth();
    }

    public void paint(Graphics g, int x, int y) {
        Color col;
        ArrayList<Range> marks;
        g.setFont(this.expressionBaseFont);
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        if (this.lineStyled == null) {
            FontRenderContext ctx = ((Graphics2D)g).getFontRenderContext();
            this.lineStyled = new AttributedString[this.lineText.length];
            this.notStarts = new int[this.lineText.length][];
            this.notStops = new int[this.lineText.length][];
            for (int i = 0; i < this.lineText.length; ++i) {
                String line = this.lineText[i];
                ArrayList<Range> nots = this.lineNots.get(i);
                ArrayList<Range> subs = this.lineSubscripts.get(i);
                marks = this.lineMarks.get(i);
                this.notStarts[i] = new int[nots.size()];
                this.notStops[i] = new int[nots.size()];
                for (int j = 0; j < nots.size(); ++j) {
                    Range not = nots.get(j);
                    this.notStarts[i][j] = this.getWidth(ctx, line, not.startIndex, subs, marks);
                    this.notStops[i][j] = this.getWidth(ctx, line, not.stopIndex, subs, marks);
                }
                this.lineStyled[i] = this.style(line, line.length(), subs, marks, false);
            }
        }
        Color curCol = col = g.getColor();
        for (int i = 0; i < this.lineStyled.length; ++i) {
            Range md;
            AttributedString as = this.lineStyled[i];
            ArrayList<Range> nots = this.lineNots.get(i);
            marks = this.lineMarks.get(i);
            if (marks.isEmpty()) {
                md = new Range();
                md.startIndex = -1;
                md.stopIndex = -1;
                curCol = col;
            } else {
                md = marks.get(0);
                curCol = Color.GRAY;
            }
            g.setColor(curCol);
            g.drawString(as.getIterator(), x, y + this.lineY[i] + fm.getAscent());
            for (int j = 0; j < nots.size(); ++j) {
                Range nd = nots.get(j);
                int notY = y + this.lineY[i] - nd.depth * AppPreferences.getScaled(this.notSep);
                int startX = x + this.notStarts[i][j];
                int stopX = x + this.notStops[i][j];
                if (nd.startIndex >= md.startIndex && nd.stopIndex <= md.stopIndex) {
                    g.setColor(MARKCOLOR);
                }
                GraphicsUtil.switchToWidth(g, 2);
                g.drawLine(startX, notY, stopX, notY);
                GraphicsUtil.switchToWidth(g, 1);
                if (nd.startIndex < md.startIndex || nd.stopIndex > md.stopIndex) continue;
                g.setColor(curCol);
            }
        }
    }
}

