/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogisimVersion {
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private String separator = "";
    private String suffix = "";

    private LogisimVersion() {
    }

    public LogisimVersion(int major, int minor, int patch) {
        this(major, minor, patch, "");
    }

    public LogisimVersion(int major, int minor, int patch, String suffix) {
        suffix = suffix == null ? "" : suffix;
        String versionString = String.format("%d.%d.%d%s", major, minor, patch, suffix);
        this.initFromVersionString(versionString);
    }

    public static LogisimVersion fromString(String versionString) {
        return new LogisimVersion().initFromVersionString(versionString);
    }

    private LogisimVersion initFromVersionString(String versionString) throws IllegalArgumentException {
        int major = 0;
        int minor = 0;
        int patch = 0;
        String separator = "";
        String suffix = "";
        String pattern = "^(\\d+.\\d+.\\d+)(.*)$";
        Matcher m = Pattern.compile(pattern, 2).matcher(versionString);
        if (m.matches()) {
            String verStr = m.group(1);
            String sufStr = m.group(2);
            String[] parts = m.group(1).split("\\.");
            try {
                if (parts.length >= 1) {
                    major = Integer.parseInt(parts[0]);
                }
                if (parts.length >= 2) {
                    minor = Integer.parseInt(parts[1]);
                }
                if (parts.length >= 3) {
                    patch = Integer.parseInt(parts[2]);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Version segments must be non-negative integers, '%s' found.", verStr));
            }
            if (sufStr != null) {
                if (sufStr.length() == 1) {
                    pattern = "^[a-z]+$";
                    m = Pattern.compile(pattern, 2).matcher(sufStr);
                    if (!m.matches()) {
                        throw new IllegalArgumentException(String.format("Suffix must start with a letter, '%s' found.", sufStr));
                    }
                    suffix = sufStr;
                } else if (sufStr.length() > 1) {
                    pattern = "^(-)?([a-z][a-z\\d]*)$";
                    m = Pattern.compile(pattern, 2).matcher(sufStr);
                    if (!m.matches()) {
                        throw new IllegalArgumentException(String.format("Invalid version suffix format. '%s' found.", sufStr));
                    }
                    String sep = m.group(1);
                    separator = sep != null ? sep : "";
                    String s = m.group(2);
                    suffix = s != null ? s : "";
                }
            }
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.separator = separator;
        this.suffix = suffix;
        return this;
    }

    public int compareTo(LogisimVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0) {
            if (this.suffix.equals("") && !other.suffix.equals("")) {
                result = 1;
            } else if (!this.suffix.equals("") && other.suffix.equals("")) {
                result = -1;
            }
        }
        return result;
    }

    public boolean isStable() {
        return this.suffix.equals("");
    }

    public int hashCode() {
        return (this.major * 31 + this.minor) * 31 + this.patch + this.suffix.hashCode();
    }

    public String toString() {
        Object sfx = "";
        if (!this.suffix.equals("")) {
            sfx = this.separator + this.suffix;
        }
        return LogisimVersion.format(this.major, this.minor, this.patch, (String)sfx);
    }

    public static String format(int major, int minor, int patch) {
        return LogisimVersion.format(major, minor, patch, "");
    }

    public static String format(int major, int minor, int patch, String suffix) {
        Object result = String.format("%d.%d.%d", major, minor, patch);
        if (!suffix.equals("")) {
            result = (String)result + suffix;
        }
        return result;
    }
}

