/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.FillableCanvasObject;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Graphics;
import java.util.List;

abstract class Rectangular
extends FillableCanvasObject {
    private Bounds bounds;

    public Rectangular(int x, int y, int w, int h) {
        this.bounds = Bounds.create(x, y, w, h);
    }

    @Override
    public boolean canMoveHandle(Handle handle) {
        return true;
    }

    protected abstract boolean contains(int var1, int var2, int var3, int var4, Location var5);

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        AttributeOption type = this.getPaintType();
        if (assumeFilled && type == DrawAttr.PAINT_STROKE) {
            type = DrawAttr.PAINT_STROKE_FILL;
        }
        Bounds b = this.bounds;
        int x = b.getX();
        int y = b.getY();
        int w = b.getWidth();
        int h = b.getHeight();
        int qx = loc.getX();
        int qy = loc.getY();
        if (type == DrawAttr.PAINT_FILL) {
            return this.isInRect(qx, qy, x, y, w, h) && this.contains(x, y, w, h, loc);
        }
        if (type == DrawAttr.PAINT_STROKE) {
            int stroke = this.getStrokeWidth();
            int tol2 = Math.max(4, stroke);
            int tol = tol2 / 2;
            return this.isInRect(qx, qy, x - tol, y - tol, w + tol2, h + tol2) && this.contains(x - tol, y - tol, w + tol2, h + tol2, loc) && !this.contains(x + tol, y + tol, w - tol2, h - tol2, loc);
        }
        if (type == DrawAttr.PAINT_STROKE_FILL) {
            int tol = this.getStrokeWidth() / 2;
            return this.isInRect(qx, qy, x - tol, y - tol, w + this.getStrokeWidth(), h + this.getStrokeWidth()) && this.contains(x - tol, y - tol, w + this.getStrokeWidth(), h + this.getStrokeWidth(), loc);
        }
        return false;
    }

    protected abstract void draw(Graphics var1, int var2, int var3, int var4, int var5);

    @Override
    public Bounds getBounds() {
        int wid = this.getStrokeWidth();
        AttributeOption type = this.getPaintType();
        return wid < 2 || type == DrawAttr.PAINT_FILL ? this.bounds : this.bounds.expand(wid / 2);
    }

    private Handle[] getHandleArray(HandleGesture gesture) {
        int newY1;
        Bounds bds = this.bounds;
        int x0 = bds.getX();
        int y0 = bds.getY();
        int x1 = x0 + bds.getWidth();
        int y1 = y0 + bds.getHeight();
        if (gesture == null) {
            return new Handle[]{new Handle(this, x0, y0), new Handle(this, x1, y0), new Handle(this, x1, y1), new Handle(this, x0, y1)};
        }
        int hx = gesture.getHandle().getX();
        int hy = gesture.getHandle().getY();
        int dx = gesture.getDeltaX();
        int dy = gesture.getDeltaY();
        int newX0 = x0 == hx ? x0 + dx : x0;
        int newY0 = y0 == hy ? y0 + dy : y0;
        int newX1 = x1 == hx ? x1 + dx : x1;
        int n = newY1 = y1 == hy ? y1 + dy : y1;
        if (gesture.isShiftDown()) {
            if (gesture.isAltDown()) {
                int h;
                int w;
                if (x0 == hx) {
                    newX1 -= dx;
                }
                if (x1 == hx) {
                    newX0 -= dx;
                }
                if (y0 == hy) {
                    newY1 -= dy;
                }
                if (y1 == hy) {
                    newY0 -= dy;
                }
                if ((w = Math.abs(newX1 - newX0)) > (h = Math.abs(newY1 - newY0))) {
                    int dw = (w - h) / 2;
                    newX1 -= (newX1 > (newX0 -= (newX0 > newX1 ? 1 : -1) * dw) ? 1 : -1) * dw;
                } else {
                    int dh = (h - w) / 2;
                    newY1 -= (newY1 > (newY0 -= (newY0 > newY1 ? 1 : -1) * dh) ? 1 : -1) * dh;
                }
            } else {
                int h;
                int w = Math.abs(newX1 - newX0);
                if (w > (h = Math.abs(newY1 - newY0))) {
                    if (x0 == hx) {
                        newX0 = newX1 + (newX0 > newX1 ? 1 : -1) * h;
                    }
                    if (x1 == hx) {
                        newX1 = newX0 + (newX1 > newX0 ? 1 : -1) * h;
                    }
                } else {
                    if (y0 == hy) {
                        newY0 = newY1 + (newY0 > newY1 ? 1 : -1) * w;
                    }
                    if (y1 == hy) {
                        newY1 = newY0 + (newY1 > newY0 ? 1 : -1) * w;
                    }
                }
            }
        } else if (gesture.isAltDown()) {
            if (x0 == hx) {
                newX1 -= dx;
            }
            if (x1 == hx) {
                newX0 -= dx;
            }
            if (y0 == hy) {
                newY1 -= dy;
            }
            if (y1 == hy) {
                newY0 -= dy;
            }
        }
        return new Handle[]{new Handle(this, newX0, newY0), new Handle(this, newX1, newY0), new Handle(this, newX1, newY1), new Handle(this, newX0, newY1)};
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        return UnmodifiableList.create(this.getHandleArray(gesture));
    }

    public int getHeight() {
        return this.bounds.getHeight();
    }

    public int getWidth() {
        return this.bounds.getWidth();
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    boolean isInRect(int qx, int qy, int x0, int y0, int w, int h) {
        return qx >= x0 && qx < x0 + w && qy >= y0 && qy < y0 + h;
    }

    @Override
    public boolean matches(CanvasObject other) {
        if (other instanceof Rectangular) {
            Rectangular that = (Rectangular)other;
            return this.bounds.equals(that.bounds) && super.matches(that);
        }
        return false;
    }

    @Override
    public int matchesHashCode() {
        return this.bounds.hashCode() * 31 + super.matchesHashCode();
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        Handle[] oldHandles = this.getHandleArray(null);
        Handle[] newHandles = this.getHandleArray(gesture);
        Handle moved = gesture == null ? null : gesture.getHandle();
        Handle result = null;
        int x0 = Integer.MAX_VALUE;
        int x1 = Integer.MIN_VALUE;
        int y0 = Integer.MAX_VALUE;
        int y1 = Integer.MIN_VALUE;
        int i = -1;
        for (Handle h : newHandles) {
            if (oldHandles[++i].equals(moved)) {
                result = h;
            }
            int hx = h.getX();
            int hy = h.getY();
            if (hx < x0) {
                x0 = hx;
            }
            if (hx > x1) {
                x1 = hx;
            }
            if (hy < y0) {
                y0 = hy;
            }
            if (hy <= y1) continue;
            y1 = hy;
        }
        this.bounds = Bounds.create(x0, y0, x1 - x0, y1 - y0);
        return result;
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        if (gesture == null) {
            Bounds bds = this.bounds;
            this.draw(g, bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        } else {
            int t;
            Handle[] handles = this.getHandleArray(gesture);
            Handle p0 = handles[0];
            Handle p1 = handles[2];
            int x0 = p0.getX();
            int y0 = p0.getY();
            int x1 = p1.getX();
            int y1 = p1.getY();
            if (x1 < x0) {
                t = x0;
                x0 = x1;
                x1 = t;
            }
            if (y1 < y0) {
                t = y0;
                y0 = y1;
                y1 = t;
            }
            this.draw(g, x0, y0, x1 - x0, y1 - y0);
        }
    }

    @Override
    public void translate(int dx, int dy) {
        this.bounds = this.bounds.translate(dx, dy);
    }
}

