/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.FillableCanvasObject;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.shapes.PolyUtil;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Graphics;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Poly
extends FillableCanvasObject {
    private final boolean closed;
    private Handle[] handles;
    private GeneralPath path;
    private double[] lens;
    private Bounds bounds;

    public Poly(boolean closed, List<Location> locations) {
        Handle[] hs = new Handle[locations.size()];
        int i = -1;
        for (Location loc : locations) {
            hs[++i] = new Handle(this, loc.getX(), loc.getY());
        }
        this.closed = closed;
        this.handles = hs;
        this.recomputeBounds();
    }

    @Override
    public Handle canDeleteHandle(Location loc) {
        Handle[] hs = this.handles;
        int minHandles = this.closed ? 3 : 2;
        if (hs.length > minHandles) {
            int qx = loc.getX();
            int qy = loc.getY();
            int w = Math.max(2, this.getStrokeWidth() / 2);
            for (Handle h : hs) {
                int hy;
                int hx = h.getX();
                if (!(LineUtil.distance(qx, qy, hx, hy = h.getY()) < (double)(w * w))) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public Handle canInsertHandle(Location loc) {
        PolyUtil.ClosestResult result = PolyUtil.getClosestPoint(loc, this.closed, this.handles);
        int thresh = Math.max(2, this.getStrokeWidth() / 2);
        if (result.getDistanceSq() < (double)(thresh * thresh)) {
            Location resLoc = result.getLocation();
            return result.getPreviousHandle().isAt(resLoc) || result.getNextHandle().isAt(resLoc) ? null : new Handle(this, result.getLocation());
        }
        return null;
    }

    @Override
    public boolean canMoveHandle(Handle handle) {
        return true;
    }

    @Override
    public Poly clone() {
        Poly ret = (Poly)super.clone();
        Handle[] hs = (Handle[])this.handles.clone();
        int n = hs.length;
        for (int i = 0; i < n; ++i) {
            Handle oldHandle = hs[i];
            hs[i] = new Handle(ret, oldHandle.getX(), oldHandle.getY());
        }
        ret.handles = hs;
        return ret;
    }

    @Override
    public final boolean contains(Location loc, boolean assumeFilled) {
        AttributeOption type = this.getPaintType();
        if (assumeFilled && type == DrawAttr.PAINT_STROKE) {
            type = DrawAttr.PAINT_STROKE_FILL;
        }
        if (type == DrawAttr.PAINT_STROKE) {
            int thresh = Math.max(2, this.getStrokeWidth() / 2);
            PolyUtil.ClosestResult result = PolyUtil.getClosestPoint(loc, this.closed, this.handles);
            return result.getDistanceSq() < (double)(thresh * thresh);
        }
        if (type == DrawAttr.PAINT_FILL) {
            GeneralPath path = this.getPath();
            return path.contains(loc.getX(), loc.getY());
        }
        GeneralPath path = this.getPath();
        if (path.contains(loc.getX(), loc.getY())) {
            return true;
        }
        int width = this.getStrokeWidth();
        PolyUtil.ClosestResult result = PolyUtil.getClosestPoint(loc, this.closed, this.handles);
        return result.getDistanceSq() < (double)(width * width / 4);
    }

    @Override
    public Handle deleteHandle(Handle handle) {
        Handle[] hs = this.handles;
        int n = hs.length;
        Handle[] is = new Handle[n - 1];
        Handle previous = null;
        boolean deleted = false;
        for (int i = 0; i < n; ++i) {
            if (deleted) {
                is[i - 1] = hs[i];
                continue;
            }
            if (hs[i].equals(handle)) {
                if (previous == null) {
                    previous = hs[n - 1];
                }
                deleted = true;
                continue;
            }
            previous = hs[i];
            is[i] = hs[i];
        }
        this.setHandles(is);
        return previous;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.getPaintType());
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public String getDisplayName() {
        return this.closed ? Strings.S.get("shapePolygon") : Strings.S.get("shapePolyline");
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        Handle[] hs = this.handles;
        if (gesture == null) {
            return UnmodifiableList.create(hs);
        }
        Handle g = gesture.getHandle();
        Handle[] ret = new Handle[hs.length];
        int n = hs.length;
        for (int i = 0; i < n; ++i) {
            Handle h = hs[i];
            if (h.equals(g)) {
                Location r;
                int x = h.getX() + gesture.getDeltaX();
                int y = h.getY() + gesture.getDeltaY();
                if (gesture.isShiftDown()) {
                    Location prev = hs[(i + n - 1) % n].getLocation();
                    Location next = hs[(i + 1) % n].getLocation();
                    if (!this.closed) {
                        if (i == 0) {
                            prev = null;
                        }
                        if (i == n - 1) {
                            next = null;
                        }
                    }
                    if (prev == null) {
                        r = LineUtil.snapTo8Cardinals(next, x, y);
                    } else if (next == null) {
                        r = LineUtil.snapTo8Cardinals(prev, x, y);
                    } else {
                        int bd;
                        Location to = Location.create(x, y, false);
                        Location a = LineUtil.snapTo8Cardinals(prev, x, y);
                        Location b = LineUtil.snapTo8Cardinals(next, x, y);
                        int ad = a.manhattanDistanceTo(to);
                        r = ad < (bd = b.manhattanDistanceTo(to)) ? a : b;
                    }
                } else {
                    r = Location.create(x, y, false);
                }
                ret[i] = new Handle(this, r);
                continue;
            }
            ret[i] = h;
        }
        return UnmodifiableList.create(ret);
    }

    private GeneralPath getPath() {
        GeneralPath p = this.path;
        if (p != null) {
            return p;
        }
        p = new GeneralPath();
        Handle[] hs = this.handles;
        if (hs.length > 0) {
            boolean first = true;
            for (Handle h : hs) {
                if (first) {
                    p.moveTo(h.getX(), h.getY());
                    first = false;
                    continue;
                }
                p.lineTo(h.getX(), h.getY());
            }
        }
        this.path = p;
        return p;
    }

    private Location getRandomBoundaryPoint(Random rand) {
        int i;
        Handle[] hs = this.handles;
        double[] ls = this.lens;
        if (ls == null) {
            ls = new double[hs.length + (this.closed ? 1 : 0)];
            double total = 0.0;
            for (i = 0; i < ls.length; ++i) {
                int j = (i + 1) % hs.length;
                ls[i] = total += LineUtil.distance(hs[i].getX(), hs[i].getY(), hs[j].getX(), hs[j].getY());
            }
            this.lens = ls;
        }
        double pos = ls[ls.length - 1] * rand.nextDouble();
        i = 0;
        while (true) {
            if (pos < ls[i]) {
                Handle p = hs[i];
                Handle q = hs[(i + 1) % hs.length];
                double u = Math.random();
                int x = (int)Math.round((double)p.getX() + u * (double)(q.getX() - p.getX()));
                int y = (int)Math.round((double)p.getY() + u * (double)(q.getY() - p.getY()));
                return Location.create(x, y, false);
            }
            ++i;
        }
    }

    @Override
    public final Location getRandomPoint(Bounds bds, Random rand) {
        if (this.getPaintType() != DrawAttr.PAINT_STROKE) {
            return super.getRandomPoint(bds, rand);
        }
        Location ret = this.getRandomBoundaryPoint(rand);
        int w = this.getStrokeWidth();
        if (w > 1) {
            int dx = rand.nextInt(w) - w / 2;
            int dy = rand.nextInt(w) - w / 2;
            ret = ret.translate(dx, dy);
        }
        return ret;
    }

    @Override
    public void insertHandle(Handle desired, Handle previous) {
        Location loc = desired.getLocation();
        Handle[] hs = this.handles;
        Handle prev = previous == null ? PolyUtil.getClosestPoint(loc, this.closed, hs).getPreviousHandle() : previous;
        Handle[] is = new Handle[hs.length + 1];
        boolean inserted = false;
        for (int i = 0; i < hs.length; ++i) {
            if (inserted) {
                is[i + 1] = hs[i];
                continue;
            }
            if (hs[i].equals(prev)) {
                inserted = true;
                is[i] = hs[i];
                is[i + 1] = desired;
                continue;
            }
            is[i] = hs[i];
        }
        if (!inserted) {
            throw new IllegalArgumentException("no such handle");
        }
        this.setHandles(is);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean matches(CanvasObject other) {
        if (other instanceof Poly) {
            Poly that = (Poly)other;
            Handle[] a = this.handles;
            Handle[] b = that.handles;
            if (this.closed != that.closed || a.length != b.length) {
                return false;
            }
            int n = a.length;
            for (int i = 0; i < n; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return super.matches(that);
        }
        return false;
    }

    @Override
    public int matchesHashCode() {
        Handle[] hs;
        int ret = super.matchesHashCode();
        ret = ret * 3 + (this.closed ? 1 : 0);
        for (Handle h : hs = this.handles) {
            ret = ret * 31 + h.hashCode();
        }
        return ret;
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        List<Handle> hs = this.getHandles(gesture);
        Handle[] is = new Handle[hs.size()];
        int i = 0;
        for (Handle h : hs) {
            is[i++] = h;
        }
        this.setHandles(is);
        return null;
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        List<Handle> hs = this.getHandles(gesture);
        int[] xs = new int[hs.size()];
        int[] ys = new int[hs.size()];
        int i = 0;
        for (Handle h : hs) {
            xs[i] = h.getX();
            ys[i] = h.getY();
            ++i;
        }
        if (this.setForFill(g)) {
            g.fillPolygon(xs, ys, xs.length);
        }
        if (this.setForStroke(g)) {
            if (this.closed) {
                g.drawPolygon(xs, ys, xs.length);
            } else {
                g.drawPolyline(xs, ys, xs.length);
            }
        }
    }

    private void recomputeBounds() {
        Handle[] hs = this.handles;
        int x0 = hs[0].getX();
        int y0 = hs[0].getY();
        int x1 = x0;
        int y1 = y0;
        for (int i = 1; i < hs.length; ++i) {
            int x = hs[i].getX();
            int y = hs[i].getY();
            if (x < x0) {
                x0 = x;
            }
            if (x > x1) {
                x1 = x;
            }
            if (y < y0) {
                y0 = y;
            }
            if (y <= y1) continue;
            y1 = y;
        }
        Bounds bds = Bounds.create(x0, y0, x1 - x0 + 1, y1 - y0 + 1);
        int stroke = this.getStrokeWidth();
        this.bounds = stroke < 2 ? bds : bds.expand(stroke / 2);
    }

    private void setHandles(Handle[] hs) {
        this.handles = hs;
        this.lens = null;
        this.path = null;
        this.recomputeBounds();
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createPoly(doc, this);
    }

    @Override
    public void translate(int dx, int dy) {
        Handle[] hs = this.handles;
        Handle[] is = new Handle[hs.length];
        for (int i = 0; i < hs.length; ++i) {
            is[i] = new Handle(this, hs[i].getX() + dx, hs[i].getY() + dy);
        }
        this.setHandles(is);
    }
}

