/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.CurveUtil;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.FillableCanvasObject;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.QuadCurve2D;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Curve
extends FillableCanvasObject {
    private Location p0;
    private Location p1;
    private Location p2;
    private Bounds bounds;

    public Curve(Location end0, Location end1, Location ctrl) {
        this.p0 = end0;
        this.p1 = ctrl;
        this.p2 = end1;
        this.bounds = CurveUtil.getBounds(Curve.toArray(this.p0), Curve.toArray(this.p1), Curve.toArray(this.p2));
    }

    private static double[] toArray(Location loc) {
        return new double[]{loc.getX(), loc.getY()};
    }

    @Override
    public boolean canMoveHandle(Handle handle) {
        return true;
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        AttributeOption type = this.getPaintType();
        if (assumeFilled && type == DrawAttr.PAINT_STROKE) {
            type = DrawAttr.PAINT_STROKE_FILL;
        }
        if (type != DrawAttr.PAINT_FILL) {
            int thr;
            double[] p2;
            double[] p1;
            double[] p0;
            double[] q = Curve.toArray(loc);
            double[] p = CurveUtil.findNearestPoint(q, p0 = Curve.toArray(this.p0), p1 = Curve.toArray(this.p1), p2 = Curve.toArray(this.p2));
            if (p == null) {
                return false;
            }
            int stroke = this.getStrokeWidth();
            int n = thr = type == DrawAttr.PAINT_STROKE ? Math.max(2, stroke / 2) : stroke / 2;
            if (LineUtil.distanceSquared(p[0], p[1], q[0], q[1]) < (double)(thr * thr)) {
                return true;
            }
        }
        return type != DrawAttr.PAINT_STROKE ? this.getCurve(null).contains(loc.getX(), loc.getY()) : false;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.getPaintType());
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    public Location getControl() {
        return this.p1;
    }

    private QuadCurve2D getCurve(HandleGesture gesture) {
        Handle[] p = this.getHandleArray(gesture);
        return new QuadCurve2D.Double(p[0].getX(), p[0].getY(), p[1].getX(), p[1].getY(), p[2].getX(), p[2].getY());
    }

    public QuadCurve2D getCurve2D() {
        return new QuadCurve2D.Double(this.p0.getX(), this.p0.getY(), this.p1.getX(), this.p1.getY(), this.p2.getX(), this.p2.getY());
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeCurve");
    }

    public Location getEnd0() {
        return this.p0;
    }

    public Location getEnd1() {
        return this.p2;
    }

    private Handle[] getHandleArray(HandleGesture gesture) {
        if (gesture == null) {
            return new Handle[]{new Handle(this, this.p0), new Handle(this, this.p1), new Handle(this, this.p2)};
        }
        Handle g = gesture.getHandle();
        int gx = g.getX() + gesture.getDeltaX();
        int gy = g.getY() + gesture.getDeltaY();
        Handle[] ret = new Handle[]{new Handle(this, this.p0), new Handle(this, this.p1), new Handle(this, this.p2)};
        if (g.isAt(this.p0)) {
            ret[0] = gesture.isShiftDown() ? new Handle(this, LineUtil.snapTo8Cardinals(this.p2, gx, gy)) : new Handle(this, gx, gy);
        } else if (g.isAt(this.p2)) {
            ret[2] = gesture.isShiftDown() ? new Handle(this, LineUtil.snapTo8Cardinals(this.p0, gx, gy)) : new Handle(this, gx, gy);
        } else if (g.isAt(this.p1)) {
            if (gesture.isShiftDown()) {
                int x0 = this.p0.getX();
                int y0 = this.p0.getY();
                int x1 = this.p2.getX();
                int y1 = this.p2.getY();
                int midx = (x0 + x1) / 2;
                int midy = (y0 + y1) / 2;
                int dx = x1 - x0;
                int dy = y1 - y0;
                double[] p = LineUtil.nearestPointInfinite(gx, gy, midx, midy, midx - dy, midy + dx);
                gx = (int)Math.round(p[0]);
                gy = (int)Math.round(p[1]);
            }
            if (gesture.isAltDown()) {
                double[] e0 = new double[]{this.p0.getX(), this.p0.getY()};
                double[] e1 = new double[]{this.p2.getX(), this.p2.getY()};
                double[] mid = new double[]{gx, gy};
                double[] ct = CurveUtil.interpolate(e0, e1, mid);
                gx = (int)Math.round(ct[0]);
                gy = (int)Math.round(ct[1]);
            }
            ret[1] = new Handle(this, gx, gy);
        }
        return ret;
    }

    public List<Handle> getHandles() {
        return UnmodifiableList.create(this.getHandleArray(null));
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        return UnmodifiableList.create(this.getHandleArray(gesture));
    }

    @Override
    public boolean matches(CanvasObject other) {
        boolean bl;
        if (other instanceof Curve) {
            Curve that = (Curve)other;
            bl = this.p0.equals(that.p0) && this.p1.equals(that.p1) && this.p2.equals(that.p2) && super.matches(that);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int matchesHashCode() {
        int ret = this.p0.hashCode();
        ret = ret * 31 * 31 + this.p1.hashCode();
        ret = ret * 31 * 31 + this.p2.hashCode();
        ret = ret * 31 + super.matchesHashCode();
        return ret;
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        Handle[] hs = this.getHandleArray(gesture);
        Handle ret = null;
        if (!hs[0].getLocation().equals(this.p0)) {
            this.p0 = hs[0].getLocation();
            ret = hs[0];
        }
        if (!hs[1].getLocation().equals(this.p1)) {
            this.p1 = hs[1].getLocation();
            ret = hs[1];
        }
        if (!hs[2].getLocation().equals(this.p2)) {
            this.p2 = hs[2].getLocation();
            ret = hs[2];
        }
        this.bounds = CurveUtil.getBounds(Curve.toArray(this.p0), Curve.toArray(this.p1), Curve.toArray(this.p2));
        return ret;
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        QuadCurve2D curve = this.getCurve(gesture);
        if (this.setForFill(g)) {
            ((Graphics2D)g).fill(curve);
        }
        if (this.setForStroke(g)) {
            ((Graphics2D)g).draw(curve);
        }
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createCurve(doc, this);
    }

    @Override
    public void translate(int dx, int dy) {
        this.p0 = this.p0.translate(dx, dy);
        this.p1 = this.p1.translate(dx, dy);
        this.p2 = this.p2.translate(dx, dy);
        this.bounds = this.bounds.translate(dx, dy);
    }
}

