/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.ReorderRequest;
import com.cburch.draw.util.ZOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ModelReorderAction
extends ModelAction {
    private final List<ReorderRequest> requests;
    private final List<CanvasObject> objects;
    private final int type;

    public ModelReorderAction(CanvasModel model, List<ReorderRequest> requests) {
        super(model);
        this.requests = new ArrayList<ReorderRequest>(requests);
        this.objects = new ArrayList<CanvasObject>(requests.size());
        for (ReorderRequest req : requests) {
            this.objects.add(req.getObject());
        }
        int typeIndex = 0;
        for (ReorderRequest req : requests) {
            int from = req.getFromIndex();
            int to = req.getToIndex();
            int thisType = Integer.compare(to, from);
            if (typeIndex == 2) {
                typeIndex = thisType;
                continue;
            }
            if (typeIndex == thisType) continue;
            typeIndex = 0;
            break;
        }
        this.type = typeIndex;
    }

    public static ModelReorderAction createLower(CanvasModel model, Collection<? extends CanvasObject> objects) {
        ArrayList<ReorderRequest> reqs = new ArrayList<ReorderRequest>();
        Map<CanvasObject, Integer> zmap = ZOrder.getZIndex(objects, model);
        for (Map.Entry<CanvasObject, Integer> entry : zmap.entrySet()) {
            CanvasObject obj = entry.getKey();
            Integer from = entry.getValue();
            CanvasObject above = ZOrder.getObjectBelow(obj, model, objects);
            if (above == null) continue;
            int to = ZOrder.getZIndex(above, model);
            if (objects.contains(above)) {
                ++to;
            }
            reqs.add(new ReorderRequest(obj, from, to));
        }
        if (reqs.isEmpty()) {
            return null;
        }
        reqs.sort(ReorderRequest.ASCENDING_FROM);
        ModelReorderAction.repairRequests(reqs);
        return new ModelReorderAction(model, reqs);
    }

    public static ModelReorderAction createLowerBottom(CanvasModel model, Collection<? extends CanvasObject> objects) {
        ArrayList<ReorderRequest> reqs = new ArrayList<ReorderRequest>();
        Map<CanvasObject, Integer> zmap = ZOrder.getZIndex(objects, model);
        int to = 0;
        for (Map.Entry<CanvasObject, Integer> entry : zmap.entrySet()) {
            CanvasObject obj = entry.getKey();
            Integer from = entry.getValue();
            reqs.add(new ReorderRequest(obj, from, to));
        }
        if (reqs.isEmpty()) {
            return null;
        }
        reqs.sort(ReorderRequest.ASCENDING_FROM);
        ModelReorderAction.repairRequests(reqs);
        return new ModelReorderAction(model, reqs);
    }

    public static ModelReorderAction createRaise(CanvasModel model, Collection<? extends CanvasObject> objects) {
        ArrayList<ReorderRequest> reqs = new ArrayList<ReorderRequest>();
        Map<CanvasObject, Integer> zmap = ZOrder.getZIndex(objects, model);
        for (Map.Entry<CanvasObject, Integer> entry : zmap.entrySet()) {
            CanvasObject obj = entry.getKey();
            Integer from = entry.getValue();
            CanvasObject above = ZOrder.getObjectAbove(obj, model, objects);
            if (above == null) continue;
            int to = ZOrder.getZIndex(above, model);
            if (objects.contains(above)) {
                --to;
            }
            reqs.add(new ReorderRequest(obj, from, to));
        }
        if (reqs.isEmpty()) {
            return null;
        }
        reqs.sort(ReorderRequest.DESCENDING_FROM);
        ModelReorderAction.repairRequests(reqs);
        return new ModelReorderAction(model, reqs);
    }

    public static ModelReorderAction createRaiseTop(CanvasModel model, Collection<? extends CanvasObject> objects) {
        ArrayList<ReorderRequest> reqs = new ArrayList<ReorderRequest>();
        Map<CanvasObject, Integer> zmap = ZOrder.getZIndex(objects, model);
        int to = model.getObjectsFromBottom().size() - 1;
        for (Map.Entry<CanvasObject, Integer> entry : zmap.entrySet()) {
            CanvasObject obj = entry.getKey();
            Integer from = entry.getValue();
            reqs.add(new ReorderRequest(obj, from, to));
        }
        if (reqs.isEmpty()) {
            return null;
        }
        reqs.sort(ReorderRequest.ASCENDING_FROM);
        ModelReorderAction.repairRequests(reqs);
        return new ModelReorderAction(model, reqs);
    }

    private static void repairRequests(List<ReorderRequest> reqs) {
        int i;
        int n = reqs.size();
        for (i = 0; i < n; ++i) {
            ReorderRequest req = reqs.get(i);
            int from = req.getFromIndex();
            int to = req.getToIndex();
            for (int j = 0; j < i; ++j) {
                ReorderRequest prev = reqs.get(j);
                int prevFrom = prev.getFromIndex();
                int prevTo = prev.getToIndex();
                if (prevFrom <= from && from < prevTo) {
                    --from;
                } else if (prevTo <= from && from < prevFrom) {
                    ++from;
                }
                if (prevFrom <= to && to < prevTo) {
                    --to;
                    continue;
                }
                if (prevTo > to || to >= prevFrom) continue;
                ++to;
            }
            if (from == req.getFromIndex() && to == req.getToIndex()) continue;
            reqs.set(i, new ReorderRequest(req.getObject(), from, to));
        }
        for (i = reqs.size() - 1; i >= 0; --i) {
            ReorderRequest req = reqs.get(i);
            if (req.getFromIndex() != req.getToIndex()) continue;
            reqs.remove(i);
        }
    }

    @Override
    void doSub(CanvasModel model) {
        model.reorderObjects(this.requests);
    }

    @Override
    public String getName() {
        if (this.type < 0) {
            return Strings.S.get("actionRaise", ModelReorderAction.getShapesName(this.objects));
        }
        if (this.type > 0) {
            return Strings.S.get("actionLower", ModelReorderAction.getShapesName(this.objects));
        }
        return Strings.S.get("actionReorder", ModelReorderAction.getShapesName(this.objects));
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return this.objects;
    }

    public List<ReorderRequest> getReorderRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    @Override
    void undoSub(CanvasModel model) {
        ArrayList<ReorderRequest> inv = new ArrayList<ReorderRequest>(this.requests.size());
        for (int i = this.requests.size() - 1; i >= 0; --i) {
            ReorderRequest request = this.requests.get(i);
            inv.add(new ReorderRequest(request.getObject(), request.getToIndex(), request.getFromIndex()));
        }
        model.reorderObjects(inv);
    }
}

