/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.listeners;

import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.parts.HexField;
import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HexFieldListener
implements DocumentListener {
    private ColorModel colorModel;
    private HexField hexField;

    public void setHexField(HexField hexField) {
        this.hexField = hexField;
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processUpdate(e);
    }

    private void processUpdate(DocumentEvent e) {
        if (this.colorModel.isChanging()) {
            return;
        }
        this.hexField.aboutToChangeColor();
        String text = this.hexField.getText();
        try {
            Color color = Color.decode('#' + text);
            this.colorModel.setColor(color);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

