/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import java.util.Arrays;
import java.util.List;

class PinAttributes
extends ProbeAttributes {
    public static PinAttributes instance = new PinAttributes();
    private static final List<Attribute<?>> INPIN_ATTRIBUTES = Arrays.asList(StdAttr.FACING, Pin.ATTR_TYPE, StdAttr.WIDTH, Pin.ATTR_BEHAVIOR, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, RadixOption.ATTRIBUTE, PROBEAPPEARANCE, Pin.ATTR_INITIAL);
    private static final List<Attribute<?>> TRISTATE_ATTRIBUTES = Arrays.asList(StdAttr.FACING, Pin.ATTR_TYPE, StdAttr.WIDTH, Pin.ATTR_BEHAVIOR, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, RadixOption.ATTRIBUTE, PROBEAPPEARANCE);
    private static final List<Attribute<?>> OUTPIN_ATTRIBUTES = Arrays.asList(StdAttr.FACING, Pin.ATTR_TYPE, StdAttr.WIDTH, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, RadixOption.ATTRIBUTE, PROBEAPPEARANCE);
    BitWidth width = BitWidth.ONE;
    AttributeOption type = Pin.INPUT;
    AttributeOption behavior = Pin.SIMPLE;
    Long initialValue = 0L;

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.type == Pin.INPUT ? (this.behavior == Pin.TRISTATE ? TRISTATE_ATTRIBUTES : INPIN_ATTRIBUTES) : OUTPIN_ATTRIBUTES;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave();
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == StdAttr.WIDTH) {
            return (V)this.width;
        }
        if (attr == Pin.ATTR_TYPE) {
            return (V)this.type;
        }
        if (attr == Pin.ATTR_BEHAVIOR) {
            return (V)this.behavior;
        }
        if (attr == PROBEAPPEARANCE) {
            return (V)this.appearance;
        }
        if (attr == Pin.ATTR_INITIAL) {
            return (V)this.initialValue;
        }
        return super.getValue(attr);
    }

    boolean isInput() {
        return this.type == Pin.INPUT;
    }

    boolean isOutput() {
        return this.type == Pin.OUTPUT;
    }

    Value defaultBitValue() {
        return this.isOutput() ? Value.UNKNOWN : (this.behavior == Pin.PULL_UP ? Value.TRUE : Value.FALSE);
    }

    boolean isClock() {
        if (this.isOutput()) {
            return false;
        }
        String lbl = this.getValue(StdAttr.LABEL);
        if (lbl == null) {
            return false;
        }
        return lbl.matches("(?i).*(clk|clock).*");
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == StdAttr.WIDTH) {
            BitWidth NewWidth = (BitWidth)value;
            if (this.width == NewWidth) {
                return;
            }
            this.width = (BitWidth)value;
            if (this.width.getWidth() > 8 && this.appearance == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
                super.setValue(RadixOption.ATTRIBUTE, RadixOption.RADIX_16);
            }
        } else if (attr == Pin.ATTR_TYPE) {
            if (this.type.equals(value)) {
                return;
            }
            this.type = (AttributeOption)value;
            this.fireAttributeListChanged();
        } else if (attr == Pin.ATTR_BEHAVIOR) {
            if (this.behavior.equals(value)) {
                return;
            }
            boolean attrListChanged = this.behavior == Pin.TRISTATE || value == Pin.TRISTATE;
            this.behavior = (AttributeOption)value;
            if (attrListChanged) {
                this.fireAttributeListChanged();
            }
        } else if (attr == PROBEAPPEARANCE) {
            AttributeOption newAppearance = (AttributeOption)value;
            if (this.appearance.equals(newAppearance)) {
                return;
            }
            this.appearance = newAppearance;
        } else {
            if (attr == RadixOption.ATTRIBUTE) {
                if (this.width.getWidth() == 1) {
                    super.setValue(RadixOption.ATTRIBUTE, RadixOption.RADIX_2);
                } else {
                    super.setValue(attr, value);
                }
                return;
            }
            if (attr == Pin.ATTR_INITIAL) {
                Long newInitial = (Long)value;
                if (newInitial == this.initialValue) {
                    return;
                }
                this.initialValue = newInitial;
            } else {
                super.setValue(attr, value);
                return;
            }
        }
        this.fireAttributeValueChanged(attr, value, null);
    }
}

