/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.bus;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.bus.SocBusAttributes;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusStateInfo;
import com.cburch.logisim.soc.gui.BusTransactionInsertionGui;
import com.cburch.logisim.soc.gui.ListeningFrame;
import com.cburch.logisim.soc.gui.TraceWindowTableModel;
import com.cburch.logisim.tools.CircuitStateHolder;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.StringUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SocBusMenuProvider
implements ActionListener {
    private static final int SHOW_MEMORY_MAP = 1;
    private static final int INSERT_TRANSACTION = 2;
    private static final int SHOW_TRACES = 3;
    private final HashMap<Instance, InstanceInformation> myInfo = new HashMap();

    public MenuExtender getMenu(Instance inst) {
        if (!this.myInfo.containsKey(inst)) {
            InstanceInformation instInfo = new InstanceInformation(inst, this);
            this.myInfo.put(inst, instInfo);
        }
        return new MenuProvider(inst, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InstanceMenuItem info;
        Instance inst;
        Object source = e.getSource();
        if (source instanceof InstanceMenuItem && this.myInfo.containsKey(inst = (info = (InstanceMenuItem)source).getInstance())) {
            int function = info.getFunction();
            switch (function) {
                case 1: {
                    this.myInfo.get(inst).showMemoryMap(inst);
                    break;
                }
                case 2: {
                    this.myInfo.get(inst).insertTransaction(inst, info.getCircuitState(), info.getState(), info.getName());
                    break;
                }
                case 3: {
                    this.myInfo.get(inst).showTraceWindow(inst, info.getState(), info.getHierInfo());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported function: %d", function));
                }
            }
        }
    }

    private void setParentFrame(Instance inst, Frame frame) {
        if (this.myInfo.containsKey(inst)) {
            this.myInfo.get(inst).setParentFrame(frame);
        }
    }

    public void registerBusState(SocBusStateInfo.SocBusState state, Instance instance) {
        if (!this.myInfo.containsKey(instance)) {
            this.myInfo.put(instance, new InstanceInformation(instance, this));
        }
        this.myInfo.get(instance).registerBusState(state);
    }

    public void deregisterBusState(SocBusStateInfo.SocBusState state, Instance instance) {
        if (this.myInfo.containsKey(instance)) {
            this.myInfo.get(instance).deregisterBusState(state);
        }
    }

    public static class InstanceInformation {
        private final HashMap<SocBusStateInfo.SocBusState, CircuitStateHolder.HierarchyInfo> myTraceList = new HashMap();
        private final HashMap<SocBusStateInfo.SocBusState, BusTransactionInsertionGui> myInsertionFrames = new HashMap();
        private Frame parentFrame = null;
        private TraceWindowTableModel traceModel = null;
        private ListeningFrame myTraceFrame = null;

        public InstanceInformation(Instance inst, SocBusMenuProvider parent) {
        }

        public void showMemoryMap(Instance instance) {
            SocBusInfo info = instance.getAttributeValue(SocBusAttributes.SOC_BUS_ID);
            SocBusStateInfo state = info.getSocSimulationManager().getSocBusState(info.getBusId());
            if (this.parentFrame != null) {
                this.parentFrame.addWindowListener(state);
            }
            state.setVisible(true);
        }

        public void insertTransaction(Instance instance, CircuitState circuitState, SocBusStateInfo.SocBusState state, String name) {
            if (!this.myInsertionFrames.containsKey(state)) {
                return;
            }
            if (this.myInsertionFrames.get(state) == null) {
                String id = instance.getAttributeSet().getValue(SocBusAttributes.SOC_BUS_ID).getBusId();
                SocBusStateInfo busInfo = instance.getAttributeValue(SocBusAttributes.SOC_BUS_ID).getSocSimulationManager().getSocBusState(id);
                BusTransactionInsertionGui gui = new BusTransactionInsertionGui(busInfo, id, circuitState);
                this.parentFrame.addWindowListener(gui);
                gui.setTitle(Strings.S.get("SocInsertTransWindowTitle") + " " + name);
                this.myInsertionFrames.put(state, gui);
            }
            BusTransactionInsertionGui frame = this.myInsertionFrames.get(state);
            frame.setVisible(true);
            int fstate = frame.getExtendedState();
            frame.setExtendedState(fstate &= 0xFFFFFFFE);
        }

        public void showTraceWindow(Instance instance, SocBusStateInfo.SocBusState state, CircuitStateHolder.HierarchyInfo name) {
            if (!this.myTraceList.containsKey(state)) {
                return;
            }
            if (this.myTraceList.get(state) == null) {
                this.myTraceList.put(state, name);
                if (this.traceModel != null) {
                    this.traceModel.rebuild();
                }
            }
            if (this.myTraceFrame == null) {
                this.traceModel = new TraceWindowTableModel(this.myTraceList, this);
                JTable table = new JTable(this.traceModel){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public TableCellRenderer getCellRenderer(int row, int column) {
                        return traceModel.getCellRenderer();
                    }

                    @Override
                    protected JTableHeader createDefaultTableHeader() {
                        return new JTableHeader(this.columnModel){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public String getToolTipText(MouseEvent e) {
                                Point point = e.getPoint();
                                int index = this.columnModel.getColumnIndexAtX(point.x);
                                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                                return traceModel.getColumnHeader(realIndex);
                            }
                        };
                    }
                };
                table.getTableHeader().setDefaultRenderer(this.traceModel.getHeaderRenderer());
                table.setFillsViewportHeight(true);
                table.setAutoResizeMode(0);
                this.traceModel.setColMod(table);
                this.traceModel.rebuild();
                JScrollPane scroll = new JScrollPane(table);
                scroll.setHorizontalScrollBarPolicy(30);
                scroll.setVerticalScrollBarPolicy(20);
                this.myTraceFrame = new ListeningFrame(Strings.S.getter("TraceWindowTitleDoubleClickOnTraceToRemoveTrace"));
                this.myTraceFrame.add(scroll);
                int scaledWidth = AppPreferences.getScaled(238);
                int scaledHeight = AppPreferences.getScaled(320);
                this.myTraceFrame.setSize(scaledWidth, scaledHeight);
            }
            this.myTraceFrame.setVisible(true);
            int fstate = this.myTraceFrame.getExtendedState();
            this.myTraceFrame.setExtendedState(fstate &= 0xFFFFFFFE);
        }

        public void destroyTraceWindow() {
            if (this.myTraceFrame != null) {
                this.myTraceFrame.setVisible(false);
                this.myTraceFrame.dispose();
                this.myTraceFrame = null;
                this.traceModel = null;
            }
        }

        public void setParentFrame(Frame frame) {
            this.parentFrame = frame;
        }

        public void registerBusState(SocBusStateInfo.SocBusState state) {
            if (!this.myTraceList.containsKey(state)) {
                this.myTraceList.put(state, null);
            }
            if (!this.myInsertionFrames.containsKey(state)) {
                this.myInsertionFrames.put(state, null);
            }
        }

        public void deregisterBusState(SocBusStateInfo.SocBusState state) {
            if (this.myTraceList.containsKey(state)) {
                this.myTraceList.remove(state);
                if (this.traceModel != null) {
                    this.traceModel.rebuild();
                }
                if (this.traceModel != null && this.traceModel.getColumnCount() == 0) {
                    this.myTraceFrame.setVisible(false);
                    this.myTraceFrame.dispose();
                    this.myTraceFrame = null;
                    this.traceModel = null;
                }
            }
            if (this.myInsertionFrames.containsKey(state)) {
                if (this.myInsertionFrames.get(state) != null) {
                    this.myInsertionFrames.get(state).dispose();
                }
                this.myInsertionFrames.remove(state);
            }
        }
    }

    private class MenuProvider
    implements MenuExtender,
    CircuitStateHolder {
        private final Instance instance;
        private final SocBusMenuProvider parent;
        SocBusStateInfo.SocBusState data;
        CircuitState circuitState;
        CircuitStateHolder.HierarchyInfo hierarchy;

        public MenuProvider(Instance inst, SocBusMenuProvider parent) {
            this.instance = inst;
            this.parent = parent;
            this.circuitState = null;
            this.data = null;
            this.hierarchy = null;
        }

        @Override
        public void configureMenu(JPopupMenu menu, Project proj) {
            InstanceMenuItem insertTrans;
            SocBusMenuProvider.this.setParentFrame(this.instance, proj.getFrame());
            String instanceName = this.instance.getAttributeValue(StdAttr.LABEL);
            if (StringUtil.isNullOrEmpty(instanceName)) {
                Location loc = this.instance.getLocation();
                instanceName = LineBuffer.format("{{1}}@{{2}},{{3}}", this.instance.getFactory().getHDLName(this.instance.getAttributeSet()), loc.getX(), loc.getY());
            }
            Object name = this.circuitState != null ? instanceName + ": " : "";
            name = (String)name + Strings.S.get("SocBusMemMap");
            menu.addSeparator();
            InstanceMenuItem memMap = new InstanceMenuItem(this.instance, (String)name, 1);
            memMap.addActionListener(this.parent);
            memMap.setEnabled(true);
            menu.add(memMap);
            if (this.circuitState == null) {
                name = Strings.S.get("insertTrans");
                CircuitState cstate = proj.getCircuitState();
                InstanceData istate = this.instance.getData(cstate);
                insertTrans = new InstanceMenuItem(this.instance, (String)name, 2, cstate, istate, this.hierarchy);
            } else {
                name = instanceName + ": " + Strings.S.get("insertTrans");
                insertTrans = new InstanceMenuItem(this.instance, (String)name, 2, this.circuitState, this.data, this.hierarchy);
            }
            insertTrans.addActionListener(this.parent);
            insertTrans.setEnabled(true);
            menu.add(insertTrans);
            if (this.circuitState != null) {
                name = instanceName + ": " + Strings.S.get("SocBusTraceWindow");
                InstanceMenuItem traceWin = new InstanceMenuItem(this.instance, (String)name, 3, this.data, this.hierarchy);
                traceWin.addActionListener(this.parent);
                traceWin.setEnabled(true);
                menu.add(traceWin);
            }
        }

        @Override
        public void setCircuitState(CircuitState state) {
            if (state != null) {
                this.circuitState = state;
                this.data = (SocBusStateInfo.SocBusState)state.getData(this.instance.getComponent());
            }
        }

        @Override
        public void setHierarchyName(CircuitStateHolder.HierarchyInfo csh) {
            this.hierarchy = csh;
        }
    }

    private static class InstanceMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private final Instance instance;
        private final int function;
        private final SocBusStateInfo.SocBusState data;
        private final CircuitStateHolder.HierarchyInfo csh;
        private final CircuitState circuitState;

        public InstanceMenuItem(Instance inst, String label, int function, Object data, CircuitStateHolder.HierarchyInfo csh) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = (SocBusStateInfo.SocBusState)data;
            this.csh = csh;
            this.circuitState = null;
        }

        public InstanceMenuItem(Instance inst, String label, int function) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = null;
            this.csh = null;
            this.circuitState = null;
        }

        public InstanceMenuItem(Instance inst, String label, int function, CircuitState state, Object data, CircuitStateHolder.HierarchyInfo csh) {
            super(label);
            this.instance = inst;
            this.function = function;
            this.data = (SocBusStateInfo.SocBusState)data;
            this.csh = csh;
            this.circuitState = state;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public int getFunction() {
            return this.function;
        }

        public SocBusStateInfo.SocBusState getState() {
            return this.data;
        }

        public CircuitState getCircuitState() {
            return this.circuitState;
        }

        public CircuitStateHolder.HierarchyInfo getHierInfo() {
            return this.csh;
        }
    }
}

