/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.settings;

import com.cburch.logisim.prefs.AppPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class VendorSoftware {
    public static final char VENDOR_ALTERA = '\u0000';
    public static final char VENDOR_XILINX = '\u0001';
    public static final char VENDOR_VIVADO = '\u0002';
    public static final char VENDOR_OPENFPGA = '\u0003';
    public static final char VENDOR_UNKNOWN = '\u00ff';
    public static final String[] VENDORS = new String[]{"Altera", "Xilinx", "Vivado", "openFPGA"};
    private static final String XilinxName = "XilinxToolsPath";
    private static final String AlteraName = "AlteraToolsPath";
    private static final String VivadoName = "VivadoToolsPath";
    private static final String OpenFpgaName = "OpenFpgaToolsPath";
    public static final String UNKNOWN = "Unknown";
    private final char vendor;
    private final String name;
    private final String[] bin;

    public VendorSoftware(char vendor, String name, String[] bin) {
        this.vendor = vendor;
        this.name = name;
        this.bin = bin;
    }

    public String getToolPath() {
        return switch (this.vendor) {
            case '\u0000' -> AppPreferences.QuartusToolPath.get();
            case '\u0001' -> AppPreferences.ISEToolPath.get();
            case '\u0002' -> AppPreferences.VivadoToolPath.get();
            case '\u0003' -> AppPreferences.OpenFpgaToolPath.get();
            default -> UNKNOWN;
        };
    }

    public String getName() {
        return this.name;
    }

    public char getVendor() {
        return this.vendor;
    }

    public String[] getBinaries() {
        return this.bin;
    }

    public String getBinaryPath(int binPos) {
        return this.getToolPath() + File.separator + this.bin[binPos];
    }

    public static List<String> getVendorStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(VENDORS[0]);
        result.add(VENDORS[1]);
        result.add(VENDORS[2]);
        result.add(VENDORS[3]);
        return result;
    }

    public static String getVendorString(char vendor) {
        return switch (vendor) {
            case '\u0000' -> VENDORS[0];
            case '\u0001' -> VENDORS[1];
            case '\u0002' -> VENDORS[2];
            case '\u0003' -> VENDORS[3];
            default -> UNKNOWN;
        };
    }

    public static VendorSoftware getSoftware(char vendor) {
        return switch (vendor) {
            case '\u0000' -> new VendorSoftware('\u0000', AlteraName, VendorSoftware.load('\u0000'));
            case '\u0001' -> new VendorSoftware('\u0001', XilinxName, VendorSoftware.load('\u0001'));
            case '\u0002' -> new VendorSoftware('\u0002', VivadoName, VendorSoftware.load('\u0002'));
            case '\u0003' -> new VendorSoftware('\u0003', OpenFpgaName, VendorSoftware.load('\u0003'));
            default -> null;
        };
    }

    public static String getToolPath(char vendor) {
        return switch (vendor) {
            case '\u0000' -> AppPreferences.QuartusToolPath.get();
            case '\u0001' -> AppPreferences.ISEToolPath.get();
            case '\u0002' -> AppPreferences.VivadoToolPath.get();
            case '\u0003' -> AppPreferences.OpenFpgaToolPath.get();
            default -> null;
        };
    }

    public static boolean setToolPath(char vendor, String path) {
        if (!VendorSoftware.toolsPresent(vendor, path)) {
            return false;
        }
        switch (vendor) {
            case '\u0000': {
                AppPreferences.QuartusToolPath.set(path);
                return true;
            }
            case '\u0001': {
                AppPreferences.ISEToolPath.set(path);
                return true;
            }
            case '\u0002': {
                AppPreferences.VivadoToolPath.set(path);
                return true;
            }
            case '\u0003': {
                AppPreferences.OpenFpgaToolPath.set(path);
                return true;
            }
        }
        return false;
    }

    private static String correctPath(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    private static String[] load(char vendor) {
        ArrayList<String> progs = new ArrayList<String>();
        String windowsExtension = ".exe";
        if (vendor == '\u0000') {
            progs.add("quartus_sh");
            progs.add("quartus_pgm");
            progs.add("quartus_map");
            progs.add("quartus_cpf");
        } else if (vendor == '\u0001') {
            progs.add("xst");
            progs.add("ngdbuild");
            progs.add("map");
            progs.add("par");
            progs.add("bitgen");
            progs.add("impact");
            progs.add("cpldfit");
            progs.add("hprep6");
        } else if (vendor == '\u0002') {
            progs.add("vivado");
            windowsExtension = ".bat";
        } else if (vendor == '\u0003') {
            progs.add("ghdl");
            progs.add("yosys");
            progs.add("nextpnr-ecp5");
            progs.add("ecppack");
            progs.add("openFPGALoader");
        }
        String[] progsArray = progs.toArray(new String[0]);
        String osname = System.getProperty("os.name");
        if (osname == null) {
            throw new IllegalArgumentException("no os.name");
        }
        if (osname.toLowerCase().contains("windows")) {
            int i = 0;
            while (i < progsArray.length) {
                int n = i++;
                progsArray[n] = progsArray[n] + windowsExtension;
            }
        }
        return progsArray;
    }

    public static boolean toolsPresent(char vendor, String path) {
        String[] tools;
        for (String tool : tools = VendorSoftware.load(vendor)) {
            File test = new File(VendorSoftware.correctPath(path + tool));
            if (test.exists()) continue;
            return false;
        }
        return true;
    }
}

