/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.hdlgenerator;

import com.cburch.logisim.fpga.designrulecheck.ConnectionEnd;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.Net;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.Vhdl;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.LineBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Hdl {
    public static final String NET_NAME = "s_logisimNet";
    public static final String BUS_NAME = "s_logisimBus";
    public static final int REMARK_MARKER_LENGTH = 3;

    private Hdl() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static boolean isVhdl() {
        return AppPreferences.HdlType.get().equals("VHDL");
    }

    public static boolean isVerilog() {
        return AppPreferences.HdlType.get().equals("Verilog");
    }

    public static String bracketOpen() {
        return Hdl.isVhdl() ? "(" : "[";
    }

    public static String bracketClose() {
        return Hdl.isVhdl() ? ")" : "]";
    }

    public static String getRemarkChar() {
        return Hdl.isVhdl() ? "-" : "*";
    }

    public static String getRemarkBlockStart() {
        return Hdl.isVhdl() ? "---" : "/**";
    }

    public static String getRemarkBlockEnd() {
        return Hdl.isVhdl() ? "---" : "**/";
    }

    public static String getRemarkBlockLineStart() {
        return Hdl.isVhdl() ? "-- " : "** ";
    }

    public static String getRemarkBlockLineEnd() {
        return Hdl.isVhdl() ? " --" : " **";
    }

    public static String getLineCommentStart() {
        return Hdl.isVhdl() ? "-- " : "// ";
    }

    public static String startIf(String condition) {
        return Hdl.isVhdl() ? LineBuffer.formatHdl("IF {{1}} THEN", condition) : LineBuffer.formatHdl("if ({{1}}) begin", condition);
    }

    public static String elseStatement() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword("ELSE") : "end else begin";
    }

    public static String elseIf(String condition) {
        return Hdl.isVhdl() ? LineBuffer.formatHdl("{{1}} {{2}} {{3}}", Vhdl.getVhdlKeyword("ELSIF"), condition, Vhdl.getVhdlKeyword("THEN")) : LineBuffer.formatHdl("end else if ({{1}}) begin", condition);
    }

    public static String endIf() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword("END ") + Vhdl.getVhdlKeyword("IF") : "end";
    }

    public static String assignPreamble() {
        return Hdl.isVhdl() ? "" : "assign ";
    }

    public static String assignOperator() {
        return Hdl.isVhdl() ? " <= " : " = ";
    }

    public static String equalOperator() {
        return Hdl.isVhdl() ? " = " : "==";
    }

    public static String notEqualOperator() {
        return Hdl.isVhdl() ? " \\= " : "!=";
    }

    private static String typecast(String signal, boolean signed) {
        return Hdl.isVhdl() ? LineBuffer.formatHdl("{{1}}({{2}})", signed ? "signed" : "unsigned", signal) : (signed ? "$signed(" + signal + ")" : signal);
    }

    public static String greaterOperator(String signalOne, String signalTwo, boolean signed, boolean equal) {
        return LineBuffer.formatHdl("{{1}} >{{2}} {{3}}", Hdl.typecast(signalOne, signed), equal ? "=" : "", Hdl.typecast(signalTwo, signed));
    }

    public static String lessOperator(String signalOne, String signalTwo, boolean signed, boolean equal) {
        return LineBuffer.formatHdl("{{1}} <{{2}} {{3}}", Hdl.typecast(signalOne, signed), equal ? "=" : "", Hdl.typecast(signalTwo, signed));
    }

    public static String leqOperator(String signalOne, String signalTwo, boolean signed) {
        return Hdl.lessOperator(signalOne, signalTwo, signed, true);
    }

    public static String geqOperator(String signalOne, String signalTwo, boolean signed) {
        return Hdl.greaterOperator(signalOne, signalTwo, signed, true);
    }

    public static String risingEdge(String signal) {
        return Hdl.isVhdl() ? "rising_edge(" + signal + ")" : "posedge " + signal;
    }

    public static String notOperator() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword(" NOT ") : "~";
    }

    public static String andOperator() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword(" AND ") : "&";
    }

    public static String orOperator() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword(" OR ") : "|";
    }

    public static String xorOperator() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword(" XOR ") : "^";
    }

    public static String addOperator(String signalOne, String signalTwo, boolean signed) {
        return (Hdl.isVhdl() ? "std_logic_vector(" : "") + Hdl.typecast(signalOne, signed) + " + " + Hdl.typecast(signalTwo, signed) + (Hdl.isVhdl() ? ")" : "");
    }

    public static String subOperator(String signalOne, String signalTwo, boolean signed) {
        return (Hdl.isVhdl() ? "std_logic_vector(" : "") + Hdl.typecast(signalOne, signed) + " - " + Hdl.typecast(signalTwo, signed) + (Hdl.isVhdl() ? ")" : "");
    }

    public static String shiftlOperator(String signal, int width, int distance, boolean arithmetic) {
        if (distance == 0) {
            return signal;
        }
        return Hdl.isVhdl() ? LineBuffer.formatHdl("{{1}}{{2}} & {{4}}{{3}}{{4}}", signal, Hdl.splitVector(width - 1 - distance, 0), "0".repeat(distance), distance == 1 ? "'" : "\"") : LineBuffer.formatHdl("{{{1}}{{2}},{{{3}}{1'b0}}}", signal, Hdl.splitVector(width - 1 - distance, 0), distance);
    }

    public static String shiftrOperator(String signal, int width, int distance, boolean arithmetic) {
        if (distance == 0) {
            return signal;
        }
        if (arithmetic) {
            return Hdl.isVhdl() ? LineBuffer.formatHdl("({{1}}{{2}}0 => {{3}}({{1}})) & {{3}}{{4}}", width - 1, Hdl.vectorLoopId(), signal, Hdl.splitVector(width - 1, width - distance)) : LineBuffer.formatHdl("{ {{{1}}{{{2}}[{{1}}-1]}},{{2}}{{3}}}", width, signal, Hdl.splitVector(width - 1, width - distance));
        }
        return Hdl.isVhdl() ? LineBuffer.formatHdl("{{1}}{{2}}{{1}} & {{3}}{{4}", distance == 1 ? "'" : "\"", "0".repeat(distance), signal, Hdl.splitVector(width - 1, width - distance)) : LineBuffer.formatHdl("{ {{{1}}{1'b0}},{{2}}{{3}}}", width, signal, Hdl.splitVector(width - 1, width - distance));
    }

    public static String sllOperator(String signal, int width, int distance) {
        return Hdl.shiftlOperator(signal, width, distance, false);
    }

    public static String slaOperator(String signal, int width, int distance) {
        return Hdl.shiftlOperator(signal, width, distance, true);
    }

    public static String srlOperator(String signal, int width, int distance) {
        return Hdl.shiftrOperator(signal, width, distance, false);
    }

    public static String sraOperator(String signal, int width, int distance) {
        return Hdl.shiftrOperator(signal, width, distance, true);
    }

    public static String rolOperator(String signal, int width, int distance) {
        return LineBuffer.formatHdl("{{1}}{{2}}{{3}}{{1}}{{4}}", signal, Hdl.splitVector(width - 1 - distance, 0), Hdl.isVhdl() ? " & " : ",", Hdl.splitVector(width - 1, width - distance));
    }

    public static String rorOperator(String signal, int width, int distance) {
        return LineBuffer.formatHdl("{{1}}{{2}}{{3}}{{1}}{{4}}", signal, Hdl.splitVector(distance, 0), Hdl.isVhdl() ? " & " : ",", Hdl.splitVector(width - 1, distance));
    }

    public static String zeroBit() {
        return Hdl.isVhdl() ? "'0'" : "1'b0";
    }

    public static String oneBit() {
        return Hdl.isVhdl() ? "'1'" : "1'b1";
    }

    public static String unconnected(boolean empty) {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword("OPEN") : (empty ? "" : "'bz");
    }

    public static String vectorLoopId() {
        return Hdl.isVhdl() ? Vhdl.getVhdlKeyword(" DOWNTO ") : ":";
    }

    public static String splitVector(int start, int end) {
        if (start == end) {
            return LineBuffer.formatHdl("{{<}}{{2}}{{>}}", start);
        }
        return Hdl.isVhdl() ? LineBuffer.formatHdl("({{1}}{{2}}{{3}})", start, Hdl.vectorLoopId(), end) : LineBuffer.formatHdl("[{{1}}:{{2}}]", start, end);
    }

    public static String getZeroVector(int nrOfBits, boolean floatingPinTiedToGround) {
        StringBuilder contents = new StringBuilder();
        if (Hdl.isVhdl()) {
            String hexFillValue;
            String fillValue = floatingPinTiedToGround ? "0" : "1";
            String string = hexFillValue = floatingPinTiedToGround ? "0" : "F";
            if (nrOfBits == 1) {
                contents.append("'").append(fillValue).append("'");
            } else {
                if (nrOfBits % 4 > 0) {
                    contents.append("\"");
                    contents.append(fillValue.repeat(nrOfBits % 4));
                    contents.append("\"");
                    if (nrOfBits > 3) {
                        contents.append("&");
                    }
                }
                if (nrOfBits / 4 > 0) {
                    contents.append("X\"");
                    contents.append(hexFillValue.repeat(Math.max(0, nrOfBits / 4)));
                    contents.append("\"");
                }
            }
        } else {
            contents.append(nrOfBits).append("'d");
            contents.append(floatingPinTiedToGround ? "0" : "-1");
        }
        return contents.toString();
    }

    public static String getConstantVector(long value, int nrOfBits) {
        long mask;
        int nrHexDigits = nrOfBits / 4;
        int nrSingleBits = nrOfBits % 4;
        String[] hexDigits = new String[nrHexDigits];
        StringBuilder singleBits = new StringBuilder();
        long shiftValue = value;
        for (int hexIndex = nrHexDigits - 1; hexIndex >= 0; --hexIndex) {
            long hexValue = shiftValue & 0xFL;
            shiftValue >>= 4;
            hexDigits[hexIndex] = String.format("%1X", hexValue);
        }
        StringBuilder hexValue = new StringBuilder();
        for (int hexIndex = 0; hexIndex < nrHexDigits; ++hexIndex) {
            hexValue.append(hexDigits[hexIndex]);
        }
        long l = mask = nrSingleBits == 0 ? 0L : 1L << nrSingleBits - 1;
        while (mask > 0L) {
            singleBits.append((shiftValue & mask) == 0L ? "0" : "1");
            mask >>= 1;
        }
        if (nrHexDigits > 0 && nrSingleBits > 0) {
            return Hdl.isVhdl() ? LineBuffer.format("\"{{1}}\"&X\"{{2}}\"", singleBits.toString(), hexValue.toString()) : LineBuffer.format("{{{1}}'b{{2}}, {{3}}'h{{4}}}", nrSingleBits, singleBits.toString(), nrHexDigits * 4, hexValue.toString());
        }
        if (nrHexDigits > 0) {
            return Hdl.isVhdl() ? LineBuffer.format("X\"{{1}}\"", hexValue.toString()) : LineBuffer.format("{{1}}'h{{2}}", nrHexDigits * 4, hexValue.toString());
        }
        if (Hdl.isVhdl()) {
            String vhdlTicks = nrOfBits == 1 ? "'" : "\"";
            return LineBuffer.format("{{1}}{{2}}{{1}}", vhdlTicks, singleBits.toString());
        }
        return LineBuffer.format("{{1}}'b{{2}}", nrSingleBits, singleBits.toString());
    }

    public static String getNetName(netlistComponent comp, int endIndex, boolean floatingNetTiedToGround, Netlist myNetlist) {
        String netName = "";
        if (endIndex >= 0 && endIndex < comp.nrOfEnds()) {
            String floatingValue = floatingNetTiedToGround ? Hdl.zeroBit() : Hdl.oneBit();
            ConnectionEnd thisEnd = comp.getEnd(endIndex);
            boolean isOutput = thisEnd.isOutputEnd();
            if (thisEnd.getNrOfBits() == 1) {
                ConnectionPoint solderPoint = thisEnd.get((byte)0);
                netName = solderPoint.getParentNet() == null ? LineBuffer.formatHdl(isOutput ? Hdl.unconnected(true) : floatingValue, new Object[0]) : (solderPoint.getParentNet().getBitWidth() == 1 ? LineBuffer.formatHdl("{{1}}{{2}}", NET_NAME, myNetlist.getNetId(solderPoint.getParentNet())) : LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", BUS_NAME, myNetlist.getNetId(solderPoint.getParentNet()), solderPoint.getParentNetBitIndex()));
            }
        }
        return netName;
    }

    public static String getBusEntryName(netlistComponent comp, int endIndex, boolean floatingNetTiedToGround, int bitindex, Netlist theNets) {
        String busName = "";
        if (endIndex >= 0 && endIndex < comp.nrOfEnds()) {
            ConnectionEnd thisEnd = comp.getEnd(endIndex);
            boolean isOutput = thisEnd.isOutputEnd();
            int nrOfBits = thisEnd.getNrOfBits();
            if (nrOfBits > 1 && bitindex >= 0 && bitindex < nrOfBits) {
                if (thisEnd.get((byte)bitindex).getParentNet() == null) {
                    busName = LineBuffer.formatHdl(isOutput ? Hdl.unconnected(false) : Hdl.getZeroVector(1, floatingNetTiedToGround), new Object[0]);
                } else {
                    Net connectedNet = thisEnd.get((byte)bitindex).getParentNet();
                    Byte connectedNetBitIndex = thisEnd.get((byte)bitindex).getParentNetBitIndex();
                    busName = !connectedNet.isBus() ? LineBuffer.formatHdl("{{1}}{{2}}", NET_NAME, theNets.getNetId(connectedNet)) : LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", BUS_NAME, theNets.getNetId(connectedNet), connectedNetBitIndex);
                }
            }
        }
        return busName;
    }

    public static String getBusNameContinues(netlistComponent comp, int endIndex, Netlist theNets) {
        if (endIndex < 0 || endIndex >= comp.nrOfEnds()) {
            return null;
        }
        ConnectionEnd connectionInformation = comp.getEnd(endIndex);
        int nrOfBits = connectionInformation.getNrOfBits();
        if (nrOfBits == 1) {
            return Hdl.getNetName(comp, endIndex, true, theNets);
        }
        if (!theNets.isContinuesBus(comp, endIndex)) {
            return null;
        }
        Net connectedNet = connectionInformation.get((byte)0).getParentNet();
        return LineBuffer.formatHdl("{{1}}{{2}}{{3}}", BUS_NAME, theNets.getNetId(connectedNet), Hdl.splitVector(connectionInformation.get((byte)(connectionInformation.getNrOfBits() - 1)).getParentNetBitIndex().byteValue(), connectionInformation.get((byte)0).getParentNetBitIndex().byteValue()));
    }

    public static String getBusName(netlistComponent comp, int endIndex, Netlist theNets) {
        if (endIndex < 0 || endIndex >= comp.nrOfEnds()) {
            return null;
        }
        ConnectionEnd connectionInformation = comp.getEnd(endIndex);
        int nrOfBits = connectionInformation.getNrOfBits();
        if (nrOfBits == 1) {
            return Hdl.getNetName(comp, endIndex, true, theNets);
        }
        if (!theNets.isContinuesBus(comp, endIndex)) {
            return null;
        }
        Net connectedNet = connectionInformation.get((byte)0).getParentNet();
        if (connectedNet.getBitWidth() != nrOfBits) {
            return Hdl.getBusNameContinues(comp, endIndex, theNets);
        }
        return LineBuffer.format("{{1}}{{2}}", BUS_NAME, theNets.getNetId(connectedNet));
    }

    public static String getClockNetName(netlistComponent comp, int endIndex, Netlist theNets) {
        ConnectionEnd endData;
        StringBuilder contents = new StringBuilder();
        if (theNets.getCurrentHierarchyLevel() != null && endIndex >= 0 && endIndex < comp.nrOfEnds() && (endData = comp.getEnd(endIndex)).getNrOfBits() == 1) {
            Net connectedNet = endData.get((byte)0).getParentNet();
            Byte ConnectedNetBitIndex = endData.get((byte)0).getParentNetBitIndex();
            int clocksourceid = theNets.getClockSourceId(theNets.getCurrentHierarchyLevel(), connectedNet, ConnectedNetBitIndex);
            if (clocksourceid >= 0) {
                contents.append("logisimClockTree").append(clocksourceid);
            }
        }
        return contents.toString();
    }

    public static boolean writeEntity(String targetDirectory, List<String> contents, String componentName) {
        if (!Hdl.isVhdl()) {
            return true;
        }
        if (contents.isEmpty()) {
            Reporter.report.addFatalError("INTERNAL ERROR: Empty entity description received!");
            return false;
        }
        File outFile = FileWriter.getFilePointer(targetDirectory, componentName, true);
        if (outFile == null) {
            return false;
        }
        return FileWriter.writeContents(outFile, contents);
    }

    public static boolean writeArchitecture(String targetDirectory, List<String> contents, String componentName) {
        if (CollectionUtil.isNullOrEmpty(contents)) {
            Reporter.report.addFatalErrorFmt("INTERNAL ERROR: Empty behavior description for Component '%s' received!", componentName);
            return false;
        }
        File outFile = FileWriter.getFilePointer(targetDirectory, componentName, false);
        if (outFile == null) {
            return false;
        }
        return FileWriter.writeContents(outFile, contents);
    }

    public static Map<String, String> getNetMap(String sourceName, boolean floatingPinTiedToGround, netlistComponent comp, int endIndex, Netlist theNets) {
        HashMap<String, String> netMap = new HashMap<String, String>();
        if (endIndex < 0 || endIndex >= comp.nrOfEnds()) {
            Reporter.report.addFatalError("INTERNAL ERROR: Component tried to index non-existing SolderPoint");
            return netMap;
        }
        ConnectionEnd connectionInformation = comp.getEnd(endIndex);
        boolean isOutput = connectionInformation.isOutputEnd();
        int nrOfBits = connectionInformation.getNrOfBits();
        if (nrOfBits == 1) {
            netMap.put(sourceName, Hdl.getNetName(comp, endIndex, floatingPinTiedToGround, theNets));
        } else {
            boolean connected = false;
            for (int bit = 0; bit < nrOfBits; ++bit) {
                if (connectionInformation.get((byte)bit).getParentNet() == null) continue;
                connected = true;
            }
            if (!connected) {
                netMap.put(sourceName, isOutput ? Hdl.unconnected(true) : Hdl.getZeroVector(nrOfBits, floatingPinTiedToGround));
            } else if (theNets.isContinuesBus(comp, endIndex)) {
                netMap.put(sourceName, Hdl.getBusNameContinues(comp, endIndex, theNets));
            } else if (Hdl.isVhdl()) {
                StringBuilder sourceNetName = new StringBuilder();
                for (int bit = 0; bit < nrOfBits; ++bit) {
                    sourceNetName.setLength(0);
                    sourceNetName.append(String.format("%s(%d) ", sourceName, bit));
                    ConnectionPoint solderPoint = connectionInformation.get((byte)bit);
                    if (solderPoint.getParentNet() == null) {
                        netMap.put(sourceNetName.toString(), isOutput ? Hdl.unconnected(false) : Hdl.getZeroVector(1, floatingPinTiedToGround));
                        continue;
                    }
                    if (solderPoint.getParentNet().getBitWidth() == 1) {
                        netMap.put(sourceNetName.toString(), String.format("%s%d", NET_NAME, theNets.getNetId(solderPoint.getParentNet())));
                        continue;
                    }
                    netMap.put(sourceNetName.toString(), String.format("%s%d(%d)", BUS_NAME, theNets.getNetId(solderPoint.getParentNet()), solderPoint.getParentNetBitIndex()));
                }
            } else {
                ArrayList<String> seperateSignals = new ArrayList<String>();
                for (int bit = 0; bit < nrOfBits; ++bit) {
                    ConnectionPoint solderPoint = connectionInformation.get((byte)bit);
                    if (solderPoint.getParentNet() == null) {
                        seperateSignals.add(isOutput ? "1'bZ" : Hdl.getZeroVector(1, floatingPinTiedToGround));
                        continue;
                    }
                    if (solderPoint.getParentNet().getBitWidth() == 1) {
                        seperateSignals.add(String.format("%s%d", NET_NAME, theNets.getNetId(solderPoint.getParentNet())));
                        continue;
                    }
                    seperateSignals.add(String.format("%s%d[%d]", BUS_NAME, theNets.getNetId(solderPoint.getParentNet()), solderPoint.getParentNetBitIndex()));
                }
                StringBuilder vector = new StringBuilder();
                vector.append("{");
                for (int bit = nrOfBits; bit > 0; --bit) {
                    vector.append((String)seperateSignals.get(bit - 1));
                    if (bit == 1) continue;
                    vector.append(",");
                }
                vector.append("}");
                netMap.put(sourceName, vector.toString());
            }
        }
        return netMap;
    }

    public static void addAllWiresSorted(LineBuffer contents, Map<String, String> wires) {
        int maxNameLength = 0;
        for (String wire : wires.keySet()) {
            maxNameLength = Math.max(maxNameLength, wire.length());
        }
        TreeSet<String> sortedWires = new TreeSet<String>(wires.keySet());
        for (String wire : sortedWires) {
            contents.add("{{assign}}{{1}}{{2}}{{=}}{{3}};", wire, " ".repeat(maxNameLength - wire.length()), wires.get(wire));
        }
        wires.clear();
    }

    public static List<String> getExtendedLibrary() {
        LineBuffer lines = LineBuffer.getBuffer();
        lines.addVhdlKeywords().add("\n{{library}} ieee;\n{{use}} ieee.std_logic_1164.all;\n{{use}} ieee.numeric_std.all;\n\n");
        return lines.get();
    }

    public static List<String> getStandardLibrary() {
        LineBuffer lines = LineBuffer.getBuffer();
        lines.addVhdlKeywords().add("\n{{library}} ieee;\n{{use}} ieee.std_logic_1164.all;\n\n");
        return lines.get();
    }
}

