/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import java.awt.event.MouseEvent;

public abstract class DynamicElementWithPoker
extends DynamicElement {
    private boolean isPressed = false;
    private Location anchorPosition;

    public DynamicElementWithPoker(DynamicElement.Path p, Bounds b) {
        super(p, b);
    }

    public void mousePressed(InstanceState state, MouseEvent e) {
        this.isPressed = true;
    }

    public void mouseReleased(InstanceState state, MouseEvent e) {
        if (this.isPressed) {
            this.performClickAction(state, e);
        }
        this.isPressed = false;
    }

    public void setAnchor(Location loc) {
        this.anchorPosition = loc;
    }

    public Bounds getScreenBounds(InstanceState state) {
        Direction dir = state.getAttributeValue(StdAttr.FACING);
        Location loc = state.getInstance().getLocation();
        if (dir == Direction.EAST) {
            int posX = this.bounds.getX() - this.anchorPosition.getX() + loc.getX();
            int posY = this.bounds.getY() - this.anchorPosition.getY() + loc.getY();
            return Bounds.create(posX, posY, this.bounds.getWidth(), this.bounds.getHeight());
        }
        if (dir == Direction.WEST) {
            int posX = this.anchorPosition.getX() - this.bounds.getX() - this.bounds.getWidth() + loc.getX();
            int posY = this.anchorPosition.getY() - this.bounds.getY() - this.bounds.getHeight() + loc.getY();
            return Bounds.create(posX, posY, this.bounds.getWidth(), this.bounds.getHeight());
        }
        if (dir == Direction.NORTH) {
            int posX = this.bounds.getY() - this.anchorPosition.getY() + loc.getX();
            int posY = this.bounds.getX() - this.anchorPosition.getX() - this.bounds.getWidth() + loc.getY();
            return Bounds.create(posX, posY, this.bounds.getHeight(), this.bounds.getWidth());
        }
        int posX = this.anchorPosition.getY() - this.bounds.getY() - this.bounds.getHeight() + loc.getX();
        int posY = this.bounds.getX() - this.anchorPosition.getX() + loc.getY();
        return Bounds.create(posX, posY, this.bounds.getHeight(), this.bounds.getWidth());
    }

    public Boolean mouseInside(InstanceState state, MouseEvent e) {
        Bounds b = this.getScreenBounds(state);
        return b.contains(e.getX(), e.getY());
    }

    public abstract void performClickAction(InstanceState var1, MouseEvent var2);
}

