/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.gray;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;

class CounterData
implements InstanceData,
Cloneable {
    private Value lastClock;
    private Value value;

    public CounterData(Value lastClock, Value value) {
        this.lastClock = lastClock;
        this.value = value;
    }

    public static CounterData get(InstanceState state, BitWidth width) {
        CounterData ret = (CounterData)state.getData();
        if (ret == null) {
            ret = new CounterData(null, Value.createKnown(width, 0L));
            state.setData(ret);
        } else if (!ret.value.getBitWidth().equals(width)) {
            ret.value = ret.value.extendWidth(width.getWidth(), Value.FALSE);
        }
        return ret;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean updateClock(Value value) {
        Value old = this.lastClock;
        this.lastClock = value;
        return old == Value.FALSE && value == Value.TRUE;
    }
}

