/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.util.List;

public class DrawAttr {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Font DEFAULT_FIXED_PICH_FONT = new Font("Courier 10 Pitch", 0, 12);
    public static final Font DEFAULT_NAME_FONT = new Font("Courier 10 Pitch", 1, 14);
    public static final int FIXED_FONT_HEIGHT = 12;
    public static final int FIXED_FONT_CHAR_WIDTH = 8;
    public static final int FIXED_FONT_ASCENT = 9;
    public static final int FIXED_FONT_DESCENT = 1;
    public static final AttributeOption HALIGN_LEFT = new AttributeOption(2, Strings.S.getter("alignLeft"));
    public static final AttributeOption HALIGN_CENTER = new AttributeOption(0, Strings.S.getter("alignCenter"));
    public static final AttributeOption HALIGN_RIGHT = new AttributeOption(4, Strings.S.getter("alignRight"));
    public static final AttributeOption VALIGN_TOP = new AttributeOption(8, Strings.S.getter("alignTop"));
    public static final AttributeOption VALIGN_MIDDLE = new AttributeOption(9, Strings.S.getter("alignMiddle"));
    public static final AttributeOption VALIGN_BASELINE = new AttributeOption(10, Strings.S.getter("alignBaseline"));
    public static final AttributeOption VALIGN_BOTTOM = new AttributeOption(11, Strings.S.getter("alignBottom"));
    public static final AttributeOption PAINT_STROKE = new AttributeOption("stroke", Strings.S.getter("paintStroke"));
    public static final AttributeOption PAINT_FILL = new AttributeOption("fill", Strings.S.getter("paintFill"));
    public static final AttributeOption PAINT_STROKE_FILL = new AttributeOption("both", Strings.S.getter("paintBoth"));
    public static final Attribute<Font> FONT = Attributes.forFont("font", Strings.S.getter("attrFont"));
    public static final Attribute<AttributeOption> HALIGNMENT = Attributes.forOption("halign", Strings.S.getter("attrHAlign"), new AttributeOption[]{HALIGN_LEFT, HALIGN_CENTER, HALIGN_RIGHT});
    public static final Attribute<AttributeOption> VALIGNMENT = Attributes.forOption("valign", Strings.S.getter("attrVAlign"), new AttributeOption[]{VALIGN_TOP, VALIGN_MIDDLE, VALIGN_BASELINE, VALIGN_BOTTOM});
    public static final Attribute<AttributeOption> PAINT_TYPE = Attributes.forOption("paintType", Strings.S.getter("attrPaint"), new AttributeOption[]{PAINT_STROKE, PAINT_FILL, PAINT_STROKE_FILL});
    public static final Attribute<Integer> STROKE_WIDTH = Attributes.forIntegerRange("stroke-width", Strings.S.getter("attrStrokeWidth"), 1, 8);
    public static final Attribute<Color> STROKE_COLOR = Attributes.forColor("stroke", Strings.S.getter("attrStroke"));
    public static final Attribute<Color> FILL_COLOR = Attributes.forColor("fill", Strings.S.getter("attrFill"));
    public static final Attribute<Color> TEXT_DEFAULT_FILL = Attributes.forColor("fill", Strings.S.getter("attrFill"));
    public static final Attribute<Integer> CORNER_RADIUS = Attributes.forIntegerRange("rx", Strings.S.getter("attrRx"), 1, 1000);
    public static final List<Attribute<?>> ATTRS_TEXT = DrawAttr.createAttributes(new Attribute[]{FONT, HALIGNMENT, VALIGNMENT, FILL_COLOR});
    public static final List<Attribute<?>> ATTRS_TEXT_TOOL = DrawAttr.createAttributes(new Attribute[]{FONT, HALIGNMENT, VALIGNMENT, TEXT_DEFAULT_FILL});
    public static final List<Attribute<?>> ATTRS_STROKE = DrawAttr.createAttributes(new Attribute[]{STROKE_WIDTH, STROKE_COLOR});
    private static final List<Attribute<?>> ATTRS_FILL_STROKE = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, STROKE_WIDTH, STROKE_COLOR});
    private static final List<Attribute<?>> ATTRS_FILL_FILL = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, FILL_COLOR});
    private static final List<Attribute<?>> ATTRS_FILL_BOTH = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, STROKE_WIDTH, STROKE_COLOR, FILL_COLOR});
    private static final List<Attribute<?>> ATTRS_RRECT_STROKE = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, STROKE_WIDTH, STROKE_COLOR, CORNER_RADIUS});
    private static final List<Attribute<?>> ATTRS_RRECT_FILL = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, FILL_COLOR, CORNER_RADIUS});
    private static final List<Attribute<?>> ATTRS_RRECT_BOTH = DrawAttr.createAttributes(new Attribute[]{PAINT_TYPE, STROKE_WIDTH, STROKE_COLOR, FILL_COLOR, CORNER_RADIUS});

    private DrawAttr() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    private static List<Attribute<?>> createAttributes(Attribute<?>[] values) {
        return UnmodifiableList.create(values);
    }

    public static List<Attribute<?>> getFillAttributes(AttributeOption paint) {
        if (paint.equals(PAINT_STROKE)) {
            return ATTRS_FILL_STROKE;
        }
        if (paint.equals(PAINT_FILL)) {
            return ATTRS_FILL_FILL;
        }
        return ATTRS_FILL_BOTH;
    }

    public static List<Attribute<?>> getRoundRectAttributes(AttributeOption paint) {
        if (paint.equals(PAINT_STROKE)) {
            return ATTRS_RRECT_STROKE;
        }
        if (paint.equals(PAINT_FILL)) {
            return ATTRS_RRECT_FILL;
        }
        return ATTRS_RRECT_BOTH;
    }
}

