/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx;

import com.dlsc.unitfx.QuantityInputControl;
import com.dlsc.unitfx.skins.QuantityInputFieldSkin;
import com.dlsc.unitfx.util.ControlsUtil;
import com.dlsc.unitfx.util.QuantitiesUtil;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javax.measure.Quantity;
import javax.measure.Unit;

public class QuantityInputField<Q extends Quantity<Q>>
extends QuantityInputControl<Q> {
    private final ObjectProperty<Double> precision = new SimpleObjectProperty<Double>((Object)this, "precision"){

        public void set(Double newValue) {
            if (newValue != null && newValue <= 0.0) {
                throw new IllegalArgumentException("Precision must be greater than 0.");
            }
            super.set((Object)newValue);
        }
    };
    private final ObjectProperty<Unit<Q>> precisionUnit = new SimpleObjectProperty((Object)this, "precisionUnit");
    private final ReadOnlyObjectWrapper<Quantity<Q>> precisionQuantity = new ReadOnlyObjectWrapper((Object)this, "precisionQuantity");
    private final ReadOnlyBooleanWrapper valueDirty = new ReadOnlyBooleanWrapper((Object)this, "valueDirty");
    private final BooleanProperty allowNegatives = new SimpleBooleanProperty((Object)this, "allowNegatives");
    private final ObjectProperty<Double> minimumValue = new SimpleObjectProperty((Object)this, "minimumValue");
    private final ObjectProperty<Double> maximumValue = new SimpleObjectProperty((Object)this, "maximumValue");
    private final ReadOnlyBooleanWrapper invalid = new ReadOnlyBooleanWrapper((Object)this, "invalid");
    private final ObjectProperty<Predicate<Double>> valueValidator = new SimpleObjectProperty((Object)this, "valueValidator");
    private final BooleanProperty autoFixValue = new SimpleBooleanProperty((Object)this, "autoFixValue");

    public QuantityInputField() {
        this.bindQuantityValueProperty();
        this.bindPrecisionQuantityProperty();
        this.bindValueDirtyProperty();
        this.listenForInvalidChanges();
        this.listenForAutoFixProperty();
        ControlsUtil.bindBooleanToPseudoclass((Node)this, (ObservableValue<Boolean>)this.valueDirtyProperty(), PseudoClass.getPseudoClass((String)"dirty"));
        this.getStyleClass().add((Object)"quantity-input-field");
    }

    protected Skin<?> createDefaultSkin() {
        return new QuantityInputFieldSkin(this);
    }

    public String getUserAgentStylesheet() {
        return QuantityInputField.class.getResource("quantity-input-field.css").toExternalForm();
    }

    public final void restoreValueProperty() {
        Quantity quantity = this.getValueQuantity();
        if (quantity != null) {
            this.setValue(quantity.getValue().doubleValue());
            this.setValueDirty(false);
        }
    }

    public final ObjectProperty<Double> precisionProperty() {
        return this.precision;
    }

    public final Double getPrecision() {
        return (Double)this.precisionProperty().get();
    }

    public final void setPrecision(Double precision) {
        this.precisionProperty().set((Object)precision);
    }

    public final ObjectProperty<Unit<Q>> precisionUnitProperty() {
        return this.precisionUnit;
    }

    public final Unit<Q> getPrecisionUnit() {
        return (Unit)this.precisionUnitProperty().get();
    }

    public final void setPrecisionUnit(Unit<Q> precisionUnit) {
        this.precisionUnitProperty().set(precisionUnit);
    }

    public final ReadOnlyObjectProperty<Quantity<Q>> precisionQuantityProperty() {
        return this.precisionQuantity.getReadOnlyProperty();
    }

    public final Quantity<Q> getPrecisionQuantity() {
        return (Quantity)this.precisionQuantityProperty().get();
    }

    private void setPrecisionQuantity(Quantity<Q> precisionQuantity) {
        this.precisionQuantity.set(precisionQuantity);
    }

    public final ReadOnlyBooleanProperty valueDirtyProperty() {
        return this.valueDirty.getReadOnlyProperty();
    }

    public final boolean isValueDirty() {
        return this.valueDirtyProperty().get();
    }

    private void setValueDirty(boolean valueDirty) {
        this.valueDirty.set(valueDirty);
    }

    public final BooleanProperty allowNegativesProperty() {
        return this.allowNegatives;
    }

    public final boolean isAllowNegatives() {
        return this.allowNegativesProperty().get();
    }

    public final void setAllowNegatives(boolean allowNegatives) {
        this.allowNegativesProperty().set(allowNegatives);
    }

    public final ObjectProperty<Double> minimumValueProperty() {
        return this.minimumValue;
    }

    public final Double getMinimumValue() {
        return (Double)this.minimumValueProperty().get();
    }

    public final void setMinimumValue(Double minimumValue) {
        this.minimumValueProperty().set((Object)minimumValue);
    }

    public final ObjectProperty<Double> maximumValueProperty() {
        return this.maximumValue;
    }

    public final Double getMaximumValue() {
        return (Double)this.maximumValueProperty().get();
    }

    public final void setMaximumValue(Double maximumValue) {
        this.maximumValueProperty().set((Object)maximumValue);
    }

    public final ReadOnlyBooleanProperty invalidProperty() {
        return this.invalid.getReadOnlyProperty();
    }

    public final boolean isInvalid() {
        return this.invalid.get();
    }

    private void setInvalid(boolean invalid) {
        this.invalid.set(invalid);
    }

    public final ObjectProperty<Predicate<Double>> valueValidatorProperty() {
        return this.valueValidator;
    }

    public final Predicate<Double> getValueValidator() {
        return (Predicate)this.valueValidatorProperty().get();
    }

    public final void setValueValidator(Predicate<Double> valueValidator) {
        this.valueValidatorProperty().set(valueValidator);
    }

    public final BooleanProperty autoFixValueProperty() {
        return this.autoFixValue;
    }

    public final boolean isAutoFixValue() {
        return this.autoFixValueProperty().get();
    }

    public final void setAutoFixValue(boolean autoFixValue) {
        this.autoFixValueProperty().set(autoFixValue);
    }

    private void bindQuantityValueProperty() {
        this.precisionQuantityProperty().addListener(obs -> this.updateValueQuantity());
    }

    @Override
    void updateValueQuantity() {
        Quantity quantity = QuantitiesUtil.createQuantity(this.getValue(), this.getUnit());
        Quantity<Q> precision = this.getPrecisionQuantity();
        if (quantity != null && precision != null) {
            quantity = QuantitiesUtil.roundQuantity(quantity, precision);
        }
        this.setValueQuantity(quantity);
    }

    @Override
    void updateDefaultUnit(Unit<Q> baseUnit) {
        super.updateDefaultUnit(baseUnit);
        if (this.getPrecisionUnit() == null) {
            this.setPrecisionUnit(baseUnit);
        }
    }

    private void bindPrecisionQuantityProperty() {
        InvalidationListener listener = o -> {
            Quantity<Q> precisionQ = QuantitiesUtil.createQuantity(this.getPrecision(), this.getPrecisionUnit());
            this.setPrecisionQuantity(precisionQ);
        };
        this.precisionProperty().addListener(listener);
        this.precisionUnitProperty().addListener(listener);
    }

    private void bindValueDirtyProperty() {
        InvalidationListener listener = obs -> {
            Quantity valueQuantity = this.getValueQuantity();
            Double value = this.getValue();
            Unit unit = this.getUnit();
            if (unit != null) {
                this.setValueDirty(valueQuantity != null && value == null || valueQuantity == null && value != null || value != null && valueQuantity != null && value.compareTo(valueQuantity.getValue().doubleValue()) != 0);
            }
        };
        this.valueProperty().addListener(listener);
        this.valueQuantityProperty().addListener(listener);
    }

    private void listenForInvalidChanges() {
        this.getProperties().addListener(change -> {
            if (change.getKey().equals("invalid")) {
                Boolean value = (Boolean)change.getValueAdded();
                this.setInvalid(Boolean.TRUE.equals(value));
            }
        });
    }

    private void listenForAutoFixProperty() {
        this.unitProperty().addListener((obs, oldV, newV) -> {
            Double value;
            if (this.isAutoFixValue() && (value = this.getValue()) != null && oldV != null && newV != null) {
                Quantity quantity = QuantitiesUtil.createQuantity(value, oldV);
                Quantity fixedQuantity = quantity.to(newV);
                value = fixedQuantity.getValue().doubleValue();
                this.setValue(value);
            }
        });
    }
}

