/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.util.Version;

public class InternalPreferences {
    private final ObjectProperty<Version> ignoredVersion;
    private final BooleanProperty versionCheckEnabled;
    private final ObjectProperty<Path> lastPreferencesExportPath;
    private final StringProperty userAndHost;
    private final BooleanProperty memoryStickMode;

    public InternalPreferences(Version ignoredVersion, boolean versionCheck, Path exportPath, String userAndHost, boolean memoryStickMode) {
        this.ignoredVersion = new SimpleObjectProperty((Object)ignoredVersion);
        this.versionCheckEnabled = new SimpleBooleanProperty(versionCheck);
        this.lastPreferencesExportPath = new SimpleObjectProperty((Object)exportPath);
        this.userAndHost = new SimpleStringProperty(userAndHost);
        this.memoryStickMode = new SimpleBooleanProperty(memoryStickMode);
    }

    public Version getIgnoredVersion() {
        return (Version)this.ignoredVersion.getValue();
    }

    public ObjectProperty<Version> ignoredVersionProperty() {
        return this.ignoredVersion;
    }

    public void setIgnoredVersion(Version ignoredVersion) {
        this.ignoredVersion.set((Object)ignoredVersion);
    }

    public boolean isVersionCheckEnabled() {
        return this.versionCheckEnabled.get();
    }

    public BooleanProperty versionCheckEnabledProperty() {
        return this.versionCheckEnabled;
    }

    public void setVersionCheckEnabled(boolean versionCheckEnabled) {
        this.versionCheckEnabled.set(versionCheckEnabled);
    }

    public Path getLastPreferencesExportPath() {
        return (Path)this.lastPreferencesExportPath.get();
    }

    public ObjectProperty<Path> lastPreferencesExportPathProperty() {
        return this.lastPreferencesExportPath;
    }

    public void setLastPreferencesExportPath(Path lastPreferencesExportPath) {
        this.lastPreferencesExportPath.set((Object)lastPreferencesExportPath);
    }

    public String getUserAndHost() {
        return (String)this.userAndHost.get();
    }

    public StringProperty getUserAndHostProperty() {
        return this.userAndHost;
    }

    public boolean isMemoryStickMode() {
        return this.memoryStickMode.get();
    }

    public BooleanProperty memoryStickModeProperty() {
        return this.memoryStickMode;
    }

    public void setMemoryStickMode(boolean memoryStickMode) {
        this.memoryStickMode.set(memoryStickMode);
    }
}

