/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.nio.file.Path;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.model.metadata.SaveOrder;

public class ExportPreferences {
    private final StringProperty lastExportExtension;
    private final ObjectProperty<Path> exportWorkingDirectory;
    private final ObjectProperty<SaveOrder> exportSaveOrder;
    private final ObservableList<TemplateExporter> customExporters;

    public ExportPreferences(String lastExportExtension, Path exportWorkingDirectory, SaveOrder exportSaveOrder, List<TemplateExporter> customExporters) {
        this.lastExportExtension = new SimpleStringProperty(lastExportExtension);
        this.exportWorkingDirectory = new SimpleObjectProperty((Object)exportWorkingDirectory);
        this.exportSaveOrder = new SimpleObjectProperty((Object)exportSaveOrder);
        this.customExporters = FXCollections.observableList(customExporters);
    }

    public String getLastExportExtension() {
        return (String)this.lastExportExtension.get();
    }

    public StringProperty lastExportExtensionProperty() {
        return this.lastExportExtension;
    }

    public void setLastExportExtension(String lastExportExtension) {
        this.lastExportExtension.set((Object)lastExportExtension);
    }

    public Path getExportWorkingDirectory() {
        return (Path)this.exportWorkingDirectory.get();
    }

    public ObjectProperty<Path> exportWorkingDirectoryProperty() {
        return this.exportWorkingDirectory;
    }

    public void setExportWorkingDirectory(Path exportWorkingDirectory) {
        this.exportWorkingDirectory.set((Object)exportWorkingDirectory);
    }

    public SaveOrder getExportSaveOrder() {
        return (SaveOrder)this.exportSaveOrder.get();
    }

    public ObjectProperty<SaveOrder> exportSaveOrderProperty() {
        return this.exportSaveOrder;
    }

    public void setExportSaveOrder(SaveOrder exportSaveOrder) {
        this.exportSaveOrder.set((Object)exportSaveOrder);
    }

    public ObservableList<TemplateExporter> getCustomExporters() {
        return this.customExporters;
    }

    public void setCustomExporters(List<TemplateExporter> exporters) {
        this.customExporters.clear();
        this.customExporters.addAll(exporters);
    }
}

