/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.jabref.logic.util.Version;

public final class BuildInfo {
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final String OS = System.getProperty("os.name", "UNKNOWN");
    public static final String OS_VERSION = System.getProperty("os.version", "UNKNOWN").toLowerCase(Locale.ROOT);
    public static final String OS_ARCH = System.getProperty("os.arch", "UNKNOWN").toLowerCase(Locale.ROOT);
    public static final String JAVA_VERSION = System.getProperty("java.version", "UNKNOWN").toLowerCase(Locale.ROOT);
    public final Version version;
    public final String maintainers;
    public final String year;
    public final String azureInstrumentationKey;
    public final String springerNatureAPIKey;
    public final String astrophysicsDataSystemAPIKey;
    public final String ieeeAPIKey;
    public final String scienceDirectApiKey;
    public final String minRequiredJavaVersion;
    public final boolean allowJava9;
    public final String biodiversityHeritageApiKey;
    public final String semanticScholarApiKey;

    public BuildInfo() {
        this("/build.properties");
    }

    public BuildInfo(String path) {
        Properties properties;
        block13: {
            properties = new Properties();
            try (InputStream stream = BuildInfo.class.getResourceAsStream(path);){
                if (stream == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.version = Version.parse(properties.getProperty("version"));
        this.year = properties.getProperty("year", "");
        this.maintainers = properties.getProperty("maintainers", "");
        this.azureInstrumentationKey = BuildInfo.getValue(properties, "azureInstrumentationKey", "");
        this.springerNatureAPIKey = BuildInfo.getValue(properties, "springerNatureAPIKey", "118d90a519d0fc2a01ee9715400054d4");
        this.astrophysicsDataSystemAPIKey = BuildInfo.getValue(properties, "astrophysicsDataSystemAPIKey", "tAhPRKADc6cC26mZUnAoBt3MAjCvKbuCZsB4lI3c");
        this.ieeeAPIKey = BuildInfo.getValue(properties, "ieeeAPIKey", "5jv3wyt4tt2bwcwv7jjk7pc3");
        this.scienceDirectApiKey = BuildInfo.getValue(properties, "scienceDirectApiKey", "fb82f2e692b3c72dafe5f4f1fa0ac00b");
        this.minRequiredJavaVersion = properties.getProperty("minRequiredJavaVersion", "1.8");
        this.allowJava9 = "true".equals(properties.getProperty("allowJava9", "true"));
        this.biodiversityHeritageApiKey = BuildInfo.getValue(properties, "biodiversityHeritageApiKey", "36b910b6-2eb3-46f2-b64c-9abc149925ba");
        this.semanticScholarApiKey = BuildInfo.getValue(properties, "semanticScholarApiKey", "");
    }

    private static String getValue(Properties properties, String key, String defaultValue) {
        String result = Optional.ofNullable(properties.getProperty(key)).map(value -> value.replaceAll("\\$\\{.*\\}", "")).orElse("");
        if (!result.isEmpty()) {
            return result;
        }
        return defaultValue;
    }
}

