/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import org.jabref.logic.shared.DBMSProcessor;
import org.jabref.logic.shared.DBMSSynchronizer;
import org.jabref.logic.shared.DatabaseConnection;
import org.jabref.logic.shared.listener.OracleNotificationListener;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class OracleProcessor
extends DBMSProcessor {
    private OracleConnection oracleConnection;
    private OracleNotificationListener listener;
    private DatabaseChangeRegistration databaseChangeRegistration;
    private Integer VERSION_DB_STRUCT_DEFAULT = -1;
    private Integer CURRENT_VERSION_DB_STRUCT = 0;

    public OracleProcessor(DatabaseConnection connection) {
        super(connection);
    }

    @Override
    public void setUp() throws SQLException {
        this.connection.createStatement().executeUpdate("CREATE TABLE \"ENTRY\" (\"SHARED_ID\" NUMBER NOT NULL, \"TYPE\" VARCHAR2(255) NULL, \"VERSION\" NUMBER DEFAULT 1, CONSTRAINT \"ENTRY_PK\" PRIMARY KEY (\"SHARED_ID\"))");
        this.connection.createStatement().executeUpdate("CREATE SEQUENCE \"ENTRY_SEQ\"");
        this.connection.createStatement().executeUpdate("CREATE TRIGGER \"ENTRY_T\" BEFORE INSERT ON \"ENTRY\" FOR EACH ROW BEGIN SELECT \"ENTRY_SEQ\".NEXTVAL INTO :NEW.shared_id FROM DUAL; END;");
        this.connection.createStatement().executeUpdate("CREATE TABLE \"FIELD\" (\"ENTRY_SHARED_ID\" NUMBER NOT NULL, \"NAME\" VARCHAR2(255) NOT NULL, \"VALUE\" CLOB NULL, CONSTRAINT \"ENTRY_SHARED_ID_FK\" FOREIGN KEY (\"ENTRY_SHARED_ID\") REFERENCES \"ENTRY\"(\"SHARED_ID\") ON DELETE CASCADE)");
        this.connection.createStatement().executeUpdate("CREATE TABLE \"METADATA\" (\"KEY\"  VARCHAR2(255) NULL,\"VALUE\"  CLOB NOT NULL)");
        Map<String, String> metadata = this.getSharedMetaData();
        if (metadata.get("VersionDBStructure") != null) {
            try {
                this.VERSION_DB_STRUCT_DEFAULT = Integer.valueOf(metadata.get("VersionDBStructure"));
            }
            catch (Exception e) {
                LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Integer!");
            }
        } else {
            LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Exist!");
        }
        if (this.VERSION_DB_STRUCT_DEFAULT < this.CURRENT_VERSION_DB_STRUCT) {
            metadata.put("VersionDBStructure", this.CURRENT_VERSION_DB_STRUCT.toString());
            this.setSharedMetaData(metadata);
        }
    }

    @Override
    String escape(String expression) {
        return expression;
    }

    @Override
    String escape_Table(String expression) {
        return this.escape(expression);
    }

    @Override
    Integer getCURRENT_VERSION_DB_STRUCT() {
        return this.CURRENT_VERSION_DB_STRUCT;
    }

    @Override
    public void startNotificationListener(DBMSSynchronizer dbmsSynchronizer) {
        this.listener = new OracleNotificationListener(dbmsSynchronizer);
        try {
            this.oracleConnection = (OracleConnection)this.connection;
            Properties properties = new Properties();
            properties.setProperty("DCN_NOTIFY_ROWIDS", "true");
            properties.setProperty("DCN_QUERY_CHANGE_NOTIFICATION", "true");
            this.databaseChangeRegistration = this.oracleConnection.registerDatabaseChangeNotification(properties);
            this.databaseChangeRegistration.addListener((DatabaseChangeListener)this.listener);
            try (Statement statement = this.oracleConnection.createStatement();){
                ((OracleStatement)statement).setDatabaseChangeRegistration(this.databaseChangeRegistration);
                StringBuilder selectQuery = new StringBuilder().append("SELECT 1 FROM ").append(this.escape_Table("ENTRY")).append(", ").append(this.escape_Table("METADATA"));
                statement.executeQuery(selectQuery.toString());
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during starting the notification listener", (Throwable)e);
        }
    }

    @Override
    protected void insertIntoEntryTable(List<BibEntry> entries) {
        try {
            for (BibEntry entry : entries) {
                String insertIntoEntryQuery = "INSERT INTO " + this.escape_Table("ENTRY") + "(" + this.escape("TYPE") + ") VALUES(?)";
                PreparedStatement preparedEntryStatement = this.connection.prepareStatement(insertIntoEntryQuery, new String[]{"SHARED_ID"});
                try {
                    preparedEntryStatement.setString(1, entry.getType().getName());
                    preparedEntryStatement.executeUpdate();
                    ResultSet generatedKeys = preparedEntryStatement.getGeneratedKeys();
                    try {
                        if (!generatedKeys.next()) continue;
                        entry.getSharedBibEntryData().setSharedID(generatedKeys.getInt(1));
                    }
                    finally {
                        if (generatedKeys == null) continue;
                        generatedKeys.close();
                    }
                }
                finally {
                    if (preparedEntryStatement == null) continue;
                    preparedEntryStatement.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during entry insertion", (Throwable)e);
        }
    }

    @Override
    protected void insertIntoFieldTable(List<BibEntry> bibEntries) {
        try {
            List fields = bibEntries.stream().map(entry -> new ArrayList<Field>(entry.getFields())).collect(Collectors.toList());
            StringBuilder insertFieldQuery = new StringBuilder().append("INSERT ALL");
            int numFields = 0;
            for (List entryFields : fields) {
                numFields += entryFields.size();
            }
            for (int i = 0; i < numFields; ++i) {
                insertFieldQuery.append(" INTO ").append(this.escape_Table("FIELD")).append(" (").append(this.escape("ENTRY_SHARED_ID")).append(", ").append(this.escape("NAME")).append(", ").append(this.escape("VALUE")).append(") VALUES (?, ?, ?)");
            }
            insertFieldQuery.append(" SELECT * FROM DUAL");
            try (PreparedStatement preparedFieldStatement = this.connection.prepareStatement(insertFieldQuery.toString());){
                int fieldsCompleted = 0;
                for (int entryIndex = 0; entryIndex < fields.size(); ++entryIndex) {
                    for (int entryFieldsIndex = 0; entryFieldsIndex < ((List)fields.get(entryIndex)).size(); ++entryFieldsIndex) {
                        preparedFieldStatement.setInt(3 * fieldsCompleted + 1, bibEntries.get(entryIndex).getSharedBibEntryData().getSharedID());
                        preparedFieldStatement.setString(3 * fieldsCompleted + 2, ((Field)((List)fields.get(entryIndex)).get(entryFieldsIndex)).getName());
                        preparedFieldStatement.setString(3 * fieldsCompleted + 3, bibEntries.get(entryIndex).getField((Field)((List)fields.get(entryIndex)).get(entryFieldsIndex)).get());
                        ++fieldsCompleted;
                    }
                }
                preparedFieldStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during field insertion", (Throwable)e);
        }
    }

    @Override
    public void stopNotificationListener() {
        try {
            this.oracleConnection.unregisterDatabaseChangeNotification(this.databaseChangeRegistration);
            this.oracleConnection.close();
        }
        catch (SQLException e) {
            LOGGER.error("SQL Error during stopping the notification listener", (Throwable)e);
        }
    }

    @Override
    public void notifyClients() {
    }
}

