/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.formatter.casechanger.Word;

public final class TitleParser {
    private StringBuilder buffer;
    private int wordStart;

    public List<Word> parse(String title) {
        LinkedList<Word> words = new LinkedList<Word>();
        boolean[] isProtected = TitleParser.determineProtectedChars(title);
        this.reset();
        int index = 0;
        for (char c : title.toCharArray()) {
            if (Character.isWhitespace(c)) {
                this.createWord(isProtected).ifPresent(words::add);
            } else {
                if (this.wordStart == -1) {
                    this.wordStart = index;
                }
                this.buffer.append(c);
            }
            ++index;
        }
        this.createWord(isProtected).ifPresent(words::add);
        return words;
    }

    private Optional<Word> createWord(boolean[] isProtected) {
        if (this.buffer.length() <= 0) {
            return Optional.empty();
        }
        char[] chars = this.buffer.toString().toCharArray();
        boolean[] protectedChars = new boolean[chars.length];
        System.arraycopy(isProtected, this.wordStart, protectedChars, 0, chars.length);
        this.reset();
        return Optional.of(new Word(chars, protectedChars));
    }

    private void reset() {
        this.wordStart = -1;
        this.buffer = new StringBuilder();
    }

    private static boolean[] determineProtectedChars(String title) {
        boolean[] isProtected = new boolean[title.length()];
        char[] chars = title.toCharArray();
        int brackets = 0;
        for (int i = 0; i < title.length(); ++i) {
            if (chars[i] == '{') {
                ++brackets;
                continue;
            }
            if (chars[i] == '}') {
                --brackets;
                continue;
            }
            isProtected[i] = brackets > 0;
        }
        return isProtected;
    }
}

