/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;

public class LowerCaseFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("lower case", new Object[0]);
    }

    @Override
    public String getKey() {
        return "lower_case";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().forEach(Word::toLowerCase);
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("changes all letters to lower case.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "KDE {Amarok}";
    }
}

