/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.formatter.IdentityFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToUnicodeFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeDateFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeMonthFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import org.jabref.logic.formatter.bibtexfields.OrdinalsToSuperscriptFormatter;
import org.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.layout.format.ReplaceUnicodeLigaturesFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldFormatterCleanups {
    public static final List<FieldFormatterCleanup> DEFAULT_SAVE_ACTIONS;
    public static final List<FieldFormatterCleanup> RECOMMEND_BIBTEX_ACTIONS;
    public static final List<FieldFormatterCleanup> RECOMMEND_BIBLATEX_ACTIONS;
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    private static final Logger LOGGER;
    private static final Pattern FIELD_FORMATTER_CLEANUP_PATTERN;
    private final boolean enabled;
    private final List<FieldFormatterCleanup> actions;

    public FieldFormatterCleanups(boolean enabled, List<FieldFormatterCleanup> actions) {
        this.enabled = enabled;
        this.actions = Objects.requireNonNull(actions);
    }

    public static String getMetaDataString(List<FieldFormatterCleanup> actionList, String newLineSeparator) {
        LinkedHashMap groupedByField = new LinkedHashMap();
        for (FieldFormatterCleanup cleanup : actionList) {
            List formattersForKey;
            Field key = cleanup.getField();
            if (!groupedByField.containsKey(key)) {
                groupedByField.put(key, new ArrayList());
            }
            if ((formattersForKey = (List)groupedByField.get(key)).contains(cleanup.getFormatter().getKey())) continue;
            formattersForKey.add(cleanup.getFormatter().getKey());
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : groupedByField.entrySet()) {
            result.append(((Field)entry.getKey()).getName());
            StringJoiner joiner = new StringJoiner(",", "[", "]" + newLineSeparator);
            ((List)entry.getValue()).forEach(joiner::add);
            result.append(joiner);
        }
        return result.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<FieldFormatterCleanup> getConfiguredActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public List<FieldChange> applySaveActions(BibEntry entry) {
        if (this.enabled) {
            return this.applyAllActions(entry);
        }
        return Collections.emptyList();
    }

    private List<FieldChange> applyAllActions(BibEntry entry) {
        ArrayList<FieldChange> result = new ArrayList<FieldChange>();
        for (FieldFormatterCleanup action : this.actions) {
            result.addAll(action.cleanup(entry));
        }
        return result;
    }

    public List<String> getAsStringList(String delimiter) {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        if (this.enabled) {
            stringRepresentation.add(ENABLED);
        } else {
            stringRepresentation.add(DISABLED);
        }
        String formatterString = FieldFormatterCleanups.getMetaDataString(this.actions, delimiter);
        stringRepresentation.add(formatterString);
        return stringRepresentation;
    }

    public static List<FieldFormatterCleanup> parse(String formatterString) {
        if (formatterString == null || formatterString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FieldFormatterCleanup> result = new ArrayList<FieldFormatterCleanup>();
        String formatterStringWithoutLineBreaks = StringUtil.unifyLineBreaks(formatterString, "");
        Matcher matcher = FIELD_FORMATTER_CLEANUP_PATTERN.matcher(formatterStringWithoutLineBreaks);
        while (matcher.find()) {
            String fieldKey = matcher.group(1);
            Field field = FieldFactory.parseField(fieldKey);
            String fieldString = matcher.group(2);
            List<FieldFormatterCleanup> fieldFormatterCleanups = Arrays.stream(fieldString.split(",")).map(FieldFormatterCleanups::getFormatterFromString).map(formatter -> new FieldFormatterCleanup(field, (Formatter)formatter)).toList();
            result.addAll(fieldFormatterCleanups);
        }
        return result;
    }

    public static FieldFormatterCleanups parse(List<String> formatterMetaList) {
        if (formatterMetaList != null && formatterMetaList.size() >= 2) {
            boolean enablementStatus = ENABLED.equals(formatterMetaList.getFirst());
            String formatterString = formatterMetaList.get(1);
            return new FieldFormatterCleanups(enablementStatus, FieldFormatterCleanups.parse(formatterString));
        }
        return new FieldFormatterCleanups(false, DEFAULT_SAVE_ACTIONS);
    }

    static Formatter getFormatterFromString(String formatterName) {
        return Formatters.getFormatterForKey(formatterName).orElseGet(() -> {
            if (!"identity".equals(formatterName)) {
                LOGGER.info("Formatter {} not found.", (Object)formatterName);
            }
            return new IdentityFormatter();
        });
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.enabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FieldFormatterCleanups) {
            FieldFormatterCleanups other = (FieldFormatterCleanups)obj;
            return Objects.equals(this.actions, other.actions) && this.enabled == other.enabled;
        }
        return false;
    }

    public String toString() {
        return "FieldFormatterCleanups{enabled=" + this.enabled + ",actions=" + String.valueOf(this.actions) + "}";
    }

    static {
        LOGGER = LoggerFactory.getLogger(FieldFormatterCleanups.class);
        FIELD_FORMATTER_CLEANUP_PATTERN = Pattern.compile("([^\\[]+)\\[([^]]+)]");
        DEFAULT_SAVE_ACTIONS = List.of(new FieldFormatterCleanup(StandardField.PAGES, new NormalizePagesFormatter()), new FieldFormatterCleanup(StandardField.DATE, new NormalizeDateFormatter()), new FieldFormatterCleanup(StandardField.MONTH, new NormalizeMonthFormatter()), new FieldFormatterCleanup(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD, new ReplaceUnicodeLigaturesFormatter()));
        ArrayList<FieldFormatterCleanup> recommendedBibtexFormatters = new ArrayList<FieldFormatterCleanup>(DEFAULT_SAVE_ACTIONS);
        recommendedBibtexFormatters.addAll(List.of(new FieldFormatterCleanup(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD, new HtmlToLatexFormatter()), new FieldFormatterCleanup(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD, new UnicodeToLatexFormatter()), new FieldFormatterCleanup(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD, new OrdinalsToSuperscriptFormatter())));
        RECOMMEND_BIBTEX_ACTIONS = Collections.unmodifiableList(recommendedBibtexFormatters);
        ArrayList<FieldFormatterCleanup> recommendedBiblatexFormatters = new ArrayList<FieldFormatterCleanup>(DEFAULT_SAVE_ACTIONS);
        recommendedBiblatexFormatters.addAll(List.of(new FieldFormatterCleanup(StandardField.TITLE, new HtmlToUnicodeFormatter()), new FieldFormatterCleanup(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD, new LatexToUnicodeFormatter())));
        RECOMMEND_BIBLATEX_ACTIONS = Collections.unmodifiableList(recommendedBiblatexFormatters);
    }
}

