/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jabref.logic.bst.BstEntry;
import org.jabref.logic.bst.BstFunctions;
import org.jabref.logic.bst.BstLexer;
import org.jabref.logic.bst.BstParser;
import org.jabref.logic.bst.BstVMContext;
import org.jabref.logic.bst.BstVMException;
import org.jabref.logic.bst.BstVMVisitor;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class BstVM {
    protected static final Integer FALSE = 0;
    protected static final Integer TRUE = 1;
    protected final ParseTree tree;
    protected BstVMContext latestContext;
    private Path path = null;

    public BstVM(Path path) throws RecognitionException, IOException {
        this(CharStreams.fromPath((Path)path));
        this.path = path;
    }

    public BstVM(String s) throws RecognitionException {
        this((CharStream)CharStreams.fromString((String)s));
    }

    protected BstVM(CharStream bst) throws RecognitionException {
        this(BstVM.charStream2CommonTree(bst));
    }

    private BstVM(ParseTree tree) {
        this.tree = tree;
    }

    private static ParseTree charStream2CommonTree(CharStream query) {
        BstLexer lexer = new BstLexer(query);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        BstParser parser = new BstParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return parser.bstFile();
    }

    public String render(Collection<BibEntry> bibEntries, BibDatabase bibDatabase) {
        Objects.requireNonNull(bibEntries);
        List<BstEntry> entries = bibEntries.stream().map(BstEntry::new).collect(Collectors.toList());
        StringBuilder resultBuffer = new StringBuilder();
        BstVMContext bstVMContext = new BstVMContext(entries, bibDatabase, this.path);
        bstVMContext.functions().putAll(new BstFunctions(bstVMContext, resultBuffer).getBuiltInFunctions());
        bstVMContext.integers().put("entry.max$", Integer.MAX_VALUE);
        bstVMContext.integers().put("global.max$", Integer.MAX_VALUE);
        BstVMVisitor bstVMVisitor = new BstVMVisitor(bstVMContext, resultBuffer);
        bstVMVisitor.visit(this.tree);
        this.latestContext = bstVMContext;
        return resultBuffer.toString();
    }

    public String render(Collection<BibEntry> bibEntries) {
        return this.render(bibEntries, null);
    }

    protected Deque<Object> getStack() {
        if (this.latestContext != null) {
            return this.latestContext.stack();
        }
        throw new BstVMException("BstVM must have rendered at least once to provide the latest stack");
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        public static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

