/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.http.dto;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.StringWriter;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.SharedBibEntryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record BibEntryDTO(SharedBibEntryData sharingMetadata, String userComments, String citationKey, String bibtex) implements Comparable<BibEntryDTO>
{
    public static final Logger LOGGER = LoggerFactory.getLogger(BibEntryDTO.class);

    public BibEntryDTO(BibEntry bibEntry, BibDatabaseMode bibDatabaseMode, FieldPreferences fieldWriterPreferences, BibEntryTypesManager bibEntryTypesManager) {
        this(bibEntry.getSharedBibEntryData(), bibEntry.getUserComments(), bibEntry.getCitationKey().orElse(""), BibEntryDTO.convertToString(bibEntry, bibDatabaseMode, fieldWriterPreferences, bibEntryTypesManager));
    }

    private static String convertToString(BibEntry entry, BibDatabaseMode bibDatabaseMode, FieldPreferences fieldWriterPreferences, BibEntryTypesManager bibEntryTypesManager) {
        StringWriter rawEntry = new StringWriter();
        BibWriter bibWriter = new BibWriter(rawEntry, "\n");
        BibEntryWriter bibtexEntryWriter = new BibEntryWriter(new FieldWriter(fieldWriterPreferences), bibEntryTypesManager);
        try {
            bibtexEntryWriter.write(entry, bibWriter, bibDatabaseMode);
        }
        catch (IOException e) {
            LOGGER.warn("Problem creating BibTeX entry.", (Throwable)e);
            return "error";
        }
        return rawEntry.toString();
    }

    @Override
    public int compareTo(BibEntryDTO o) {
        int sharingComparison = this.sharingMetadata.compareTo(o.sharingMetadata);
        if (sharingComparison != 0) {
            return sharingComparison;
        }
        LOGGER.error("Comparing equal DTOs");
        return 0;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sharingMetadata", (Object)this.sharingMetadata).add("userComments", (Object)this.userComments).add("citationkey", (Object)this.citationKey).add("bibtex", (Object)this.bibtex).toString();
    }
}

