/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.slr;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.slr.SlrStudyAndDirectory;
import org.jabref.gui.slr.StudyCatalogItem;
import org.jabref.logic.crawler.StudyYamlParser;
import org.jabref.logic.git.GitHandler;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.study.Study;
import org.jabref.model.study.StudyDatabase;
import org.jabref.model.study.StudyQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageStudyDefinitionViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageStudyDefinitionViewModel.class);
    private static final Set<String> DEFAULT_SELECTION = Set.of("ACM Portal", "IEEEXplore", "Springer", "DBLP");
    private final StringProperty title = new SimpleStringProperty();
    private final ObservableList<String> authors = FXCollections.observableArrayList();
    private final ObservableList<String> researchQuestions = FXCollections.observableArrayList();
    private final ObservableList<String> queries = FXCollections.observableArrayList();
    private final ObservableList<StudyCatalogItem> databases = FXCollections.observableArrayList();
    private final SimpleStringProperty directory = new SimpleStringProperty();
    private final DialogService dialogService;

    public ManageStudyDefinitionViewModel(ImportFormatPreferences importFormatPreferences, ImporterPreferences importerPreferences, DialogService dialogService) {
        this.databases.addAll(WebFetchers.getSearchBasedFetchers(importFormatPreferences, importerPreferences).stream().map(WebFetcher::getName).filter(name -> !name.equals("Search Selected")).map(name -> {
            boolean enabled = DEFAULT_SELECTION.contains(name);
            return new StudyCatalogItem((String)name, enabled);
        }).toList());
        this.dialogService = Objects.requireNonNull(dialogService);
    }

    public ManageStudyDefinitionViewModel(Study study, Path studyDirectory, ImportFormatPreferences importFormatPreferences, ImporterPreferences importerPreferences, DialogService dialogService) {
        this.authors.addAll(Objects.requireNonNull(study).getAuthors());
        this.title.setValue(study.getTitle());
        this.researchQuestions.addAll(study.getResearchQuestions());
        this.queries.addAll(study.getQueries().stream().map(StudyQuery::getQuery).toList());
        List<StudyDatabase> studyDatabases = study.getDatabases();
        this.databases.addAll(WebFetchers.getSearchBasedFetchers(importFormatPreferences, importerPreferences).stream().map(WebFetcher::getName).filter(name -> !name.equals("Search Selected")).map(name -> {
            boolean enabled = studyDatabases.contains(new StudyDatabase((String)name, true));
            return new StudyCatalogItem((String)name, enabled);
        }).toList());
        this.directory.set(Objects.requireNonNull(studyDirectory).toString());
        this.dialogService = Objects.requireNonNull(dialogService);
    }

    public StringProperty getTitle() {
        return this.title;
    }

    public StringProperty getDirectory() {
        return this.directory;
    }

    public ObservableList<String> getAuthors() {
        return this.authors;
    }

    public ObservableList<String> getResearchQuestions() {
        return this.researchQuestions;
    }

    public ObservableList<String> getQueries() {
        return this.queries;
    }

    public ObservableList<StudyCatalogItem> getCatalogs() {
        return this.databases;
    }

    public void addAuthor(String author) {
        if (author.isBlank()) {
            return;
        }
        this.authors.add((Object)author);
    }

    public void addResearchQuestion(String researchQuestion) {
        if (researchQuestion.isBlank() || this.researchQuestions.contains((Object)researchQuestion)) {
            return;
        }
        this.researchQuestions.add((Object)researchQuestion);
    }

    public void addQuery(String query) {
        if (query.isBlank()) {
            return;
        }
        this.queries.add((Object)query);
    }

    public SlrStudyAndDirectory saveStudy() {
        Path studyDirectory;
        Study study = new Study((List<String>)this.authors, this.title.getValueSafe(), (List<String>)this.researchQuestions, this.queries.stream().map(StudyQuery::new).collect(Collectors.toList()), this.databases.stream().map(studyDatabaseItem -> new StudyDatabase(studyDatabaseItem.getName(), studyDatabaseItem.isEnabled())).filter(StudyDatabase::isEnabled).collect(Collectors.toList()));
        String studyDirectoryAsString = this.directory.getValueSafe();
        try {
            studyDirectory = Path.of(studyDirectoryAsString, new String[0]);
        }
        catch (InvalidPathException e) {
            LOGGER.error("Invalid path was provided: {}", (Object)studyDirectoryAsString);
            this.dialogService.notify(Localization.lang("Unable to write to %0.", studyDirectoryAsString));
            return null;
        }
        Path studyDefinitionFile = studyDirectory.resolve("study.yml");
        try {
            new StudyYamlParser().writeStudyYamlFile(study, studyDefinitionFile);
        }
        catch (IOException e) {
            LOGGER.error("Could not write study file {}", (Object)studyDefinitionFile, (Object)e);
            this.dialogService.notify(Localization.lang("Please enter a valid file path.", new Object[0]) + ": " + studyDirectoryAsString);
            return null;
        }
        try {
            new GitHandler(studyDirectory).createCommitOnCurrentBranch("Update study definition", false);
        }
        catch (Exception e) {
            LOGGER.error("Could not commit study definition file in directory {}", (Object)studyDirectory, (Object)e);
            this.dialogService.notify(Localization.lang("Please enter a valid file path.", new Object[0]) + ": " + String.valueOf(studyDirectory));
        }
        return new SlrStudyAndDirectory(study, studyDirectory);
    }

    public Property<String> titleProperty() {
        return this.title;
    }

    public void setStudyDirectory(Optional<Path> studyRepositoryRoot) {
        this.getDirectory().setValue(studyRepositoryRoot.map(Path::toString).orElseGet(() -> this.getDirectory().getValueSafe()));
    }

    public void deleteAuthor(String item) {
        this.authors.remove((Object)item);
    }

    public void deleteQuestion(String item) {
        this.researchQuestions.remove((Object)item);
    }

    public void deleteQuery(String item) {
        this.queries.remove((Object)item);
    }
}

