/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties;

import com.airhacks.afterburner.injection.Injector;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.libraryproperties.LibraryPropertiesView;
import org.jabref.model.database.BibDatabaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryPropertiesAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryPropertiesAction.class);
    private final StateManager stateManager;
    private final Supplier<BibDatabaseContext> alternateDatabase;

    public LibraryPropertiesAction(StateManager stateManager) {
        this(null, stateManager);
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public LibraryPropertiesAction(Supplier<BibDatabaseContext> databaseContext, StateManager stateManager) {
        this.stateManager = stateManager;
        this.alternateDatabase = databaseContext;
    }

    public void execute() {
        DialogService dialogService = (DialogService)Injector.instantiateModelOrService(DialogService.class);
        if (this.alternateDatabase != null) {
            dialogService.showCustomDialogAndWait(new LibraryPropertiesView(this.alternateDatabase.get()));
        } else if (this.stateManager.getActiveDatabase().isPresent()) {
            dialogService.showCustomDialogAndWait(new LibraryPropertiesView(this.stateManager.getActiveDatabase().get()));
        } else {
            LOGGER.warn("No library selected.");
        }
    }
}

