/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import com.dlsc.gemsfx.TagsField;
import de.saxsys.mvvmfx.utils.commands.Command;
import jakarta.inject.Inject;
import java.util.Comparator;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.JabRefDialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.LinkedEntriesEditorViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.ParsedEntryLink;
import org.jabref.model.entry.field.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedEntriesEditor
extends HBox
implements FieldEditorFX {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedEntriesEditor.class);
    @FXML
    public TagsField<ParsedEntryLink> entryLinkField;
    @Inject
    private DialogService dialogService;
    @Inject
    private ClipBoardManager clipBoardManager;
    @Inject
    private UndoManager undoManager;
    @Inject
    private StateManager stateManager;
    private final LinkedEntriesEditorViewModel viewModel;

    public LinkedEntriesEditor(Field field, BibDatabaseContext databaseContext, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new LinkedEntriesEditorViewModel(field, suggestionProvider, databaseContext, fieldCheckers, this.undoManager, this.stateManager);
        this.entryLinkField.setCellFactory(new ViewModelListCellFactory().withText(ParsedEntryLink::getKey));
        this.entryLinkField.setSuggestionProvider(request -> this.viewModel.getSuggestions(request.getUserText()));
        this.entryLinkField.setTagViewFactory(this::createTag);
        this.entryLinkField.setConverter(this.viewModel.getStringConverter());
        this.entryLinkField.setNewItemProducer(searchText -> (ParsedEntryLink)this.viewModel.getStringConverter().fromString(searchText));
        this.entryLinkField.setMatcher((entryLink, searchText) -> entryLink.getKey().toLowerCase().startsWith(searchText.toLowerCase()));
        this.entryLinkField.setComparator(Comparator.comparing(ParsedEntryLink::getKey));
        this.entryLinkField.setShowSearchIcon(false);
        this.entryLinkField.getEditor().getStyleClass().clear();
        this.entryLinkField.getEditor().getStyleClass().add((Object)"tags-field-editor");
        String separator = ",";
        this.entryLinkField.getEditor().setOnKeyReleased(event -> {
            if (event.getText().equals(separator)) {
                this.entryLinkField.commit();
                event.consume();
            }
        });
        Bindings.bindContentBidirectional((ObservableList)this.entryLinkField.getTags(), this.viewModel.linkedEntriesProperty());
    }

    private Node createTag(ParsedEntryLink entryLink) {
        Label tagLabel = new Label();
        tagLabel.setText(this.entryLinkField.getConverter().toString((Object)entryLink));
        tagLabel.setGraphic(IconTheme.JabRefIcons.REMOVE_TAGS.getGraphicNode());
        tagLabel.getGraphic().setOnMouseClicked(event -> this.entryLinkField.removeTags((Object[])new ParsedEntryLink[]{entryLink}));
        tagLabel.setContentDisplay(ContentDisplay.RIGHT);
        tagLabel.setOnMouseClicked(event -> {
            if ((event.getClickCount() == 2 || event.isControlDown()) && event.getButton() == MouseButton.PRIMARY) {
                this.viewModel.jumpToEntry(entryLink);
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.COPY, (Command)new TagContextAction(StandardActions.COPY, entryLink)), factory.createMenuItem(StandardActions.CUT, (Command)new TagContextAction(StandardActions.CUT, entryLink)), factory.createMenuItem(StandardActions.DELETE, (Command)new TagContextAction(StandardActions.DELETE, entryLink))});
        tagLabel.setContextMenu(contextMenu);
        return tagLabel;
    }

    public LinkedEntriesEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    private class TagContextAction
    extends SimpleCommand {
        private final StandardActions command;
        private final ParsedEntryLink entryLink;

        public TagContextAction(StandardActions command, ParsedEntryLink entryLink) {
            this.command = command;
            this.entryLink = entryLink;
        }

        public void execute() {
            switch (this.command) {
                case COPY: {
                    LinkedEntriesEditor.this.clipBoardManager.setContent(this.entryLink.getKey());
                    LinkedEntriesEditor.this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(this.entryLink.getKey())));
                    break;
                }
                case CUT: {
                    LinkedEntriesEditor.this.clipBoardManager.setContent(this.entryLink.getKey());
                    LinkedEntriesEditor.this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(this.entryLink.getKey())));
                    LinkedEntriesEditor.this.entryLinkField.removeTags((Object[])new ParsedEntryLink[]{this.entryLink});
                    break;
                }
                case DELETE: {
                    LinkedEntriesEditor.this.entryLinkField.removeTags((Object[])new ParsedEntryLink[]{this.entryLink});
                    break;
                }
                default: {
                    LOGGER.info("Action {} not defined", (Object)this.command.getText());
                }
            }
        }
    }
}

