/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.formatter.bibtexfields.RemoveHyphenatedNewlinesFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.pdf.FileAnnotation;
import org.jabref.model.pdf.FileAnnotationType;

public class FileAnnotationViewModel {
    private static final String NEWLINE = "%n".formatted(new Object[0]);
    private final FileAnnotation annotation;
    private StringProperty author = new SimpleStringProperty();
    private StringProperty page = new SimpleStringProperty();
    private StringProperty date = new SimpleStringProperty();
    private StringProperty content = new SimpleStringProperty();
    private StringProperty marking = new SimpleStringProperty();

    public FileAnnotationViewModel(FileAnnotation annotation) {
        this.annotation = annotation;
        this.author.set((Object)annotation.getAuthor());
        this.page.set((Object)Integer.toString(annotation.getPage()));
        this.date.set((Object)annotation.getTimeModified().toString().replace('T', ' '));
        this.setupContentProperties(annotation);
    }

    private void setupContentProperties(FileAnnotation annotation) {
        if (annotation.hasLinkedAnnotation()) {
            this.content.set((Object)annotation.getLinkedFileAnnotation().getContent());
            String annotationContent = annotation.getContent();
            String illegibleTextMessage = Localization.lang("The marked area does not contain any legible text!", new Object[0]);
            String markingContent = annotationContent.isEmpty() ? illegibleTextMessage : annotationContent;
            this.marking.set((Object)this.removePunctuationMark(markingContent));
        } else {
            String content = annotation.getContent();
            this.content.set((Object)this.removePunctuationMark(content));
            this.marking.set((Object)"");
        }
    }

    public String removePunctuationMark(String content) {
        content = content.replaceAll("-" + NEWLINE, "");
        content = new RemoveHyphenatedNewlinesFormatter().format(content);
        content = content.replaceAll("(?<![.|:])" + NEWLINE, " ");
        return content;
    }

    public String getAuthor() {
        return (String)this.author.get();
    }

    public String getPage() {
        return (String)this.page.get();
    }

    public String getDate() {
        return (String)this.date.get();
    }

    public String getContent() {
        return (String)this.content.get();
    }

    public StringProperty pageProperty() {
        return this.page;
    }

    public StringProperty dateProperty() {
        return this.date;
    }

    public StringProperty contentProperty() {
        return this.content;
    }

    public StringProperty markingProperty() {
        return this.marking;
    }

    public StringProperty authorProperty() {
        return this.author;
    }

    public String toString() {
        if (this.annotation.hasLinkedAnnotation() && this.getContent().isEmpty()) {
            if (FileAnnotationType.UNDERLINE == this.annotation.getAnnotationType()) {
                return Localization.lang("Empty Underline", new Object[0]);
            }
            if (FileAnnotationType.HIGHLIGHT == this.annotation.getAnnotationType()) {
                return Localization.lang("Empty Highlight", new Object[0]);
            }
            return Localization.lang("Empty Marking", new Object[0]);
        }
        if (FileAnnotationType.UNDERLINE == this.annotation.getAnnotationType()) {
            return Localization.lang("Underline", new Object[0]) + ": " + this.getContent();
        }
        if (FileAnnotationType.HIGHLIGHT == this.annotation.getAnnotationType()) {
            return Localization.lang("Highlight", new Object[0]) + ": " + this.getContent();
        }
        return super.toString();
    }

    public String getMarking() {
        return (String)this.marking.get();
    }
}

