/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.citationrelationtab;

import com.tobiasdiez.easybind.EasyBind;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.CheckListView;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.citationrelationtab.BibEntryRelationsCache;
import org.jabref.gui.entryeditor.citationrelationtab.BibEntryRelationsRepository;
import org.jabref.gui.entryeditor.citationrelationtab.BibEntryView;
import org.jabref.gui.entryeditor.citationrelationtab.CitationRelationItem;
import org.jabref.gui.entryeditor.citationrelationtab.CitationsRelationsTabViewModel;
import org.jabref.gui.entryeditor.citationrelationtab.semanticscholar.CitationFetcher;
import org.jabref.gui.entryeditor.citationrelationtab.semanticscholar.SemanticScholarFetcher;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.NoSelectionModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseModeDetection;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitationRelationsTab
extends EntryEditorTab {
    public static final String NAME = "Citation relations";
    private static final Logger LOGGER = LoggerFactory.getLogger(CitationRelationsTab.class);
    private static BackgroundTask<List<BibEntry>> citingTask;
    private static BackgroundTask<List<BibEntry>> citedByTask;
    private final DialogService dialogService;
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferencesService;
    private final LibraryTab libraryTab;
    private final TaskExecutor taskExecutor;
    private final BibEntryRelationsRepository bibEntryRelationsRepository;
    private final CitationsRelationsTabViewModel citationsRelationsTabViewModel;
    private final DuplicateCheck duplicateCheck;

    public CitationRelationsTab(DialogService dialogService, BibDatabaseContext databaseContext, UndoManager undoManager, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, PreferencesService preferencesService, LibraryTab libraryTab, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.databaseContext = databaseContext;
        this.preferencesService = preferencesService;
        this.libraryTab = libraryTab;
        this.taskExecutor = taskExecutor;
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show articles related by citation", new Object[0])));
        this.duplicateCheck = new DuplicateCheck(new BibEntryTypesManager());
        this.bibEntryRelationsRepository = new BibEntryRelationsRepository(new SemanticScholarFetcher(preferencesService.getImporterPreferences()), new BibEntryRelationsCache());
        this.citationsRelationsTabViewModel = new CitationsRelationsTabViewModel(databaseContext, preferencesService, undoManager, stateManager, dialogService, fileUpdateMonitor, taskExecutor);
    }

    private SplitPane getPaneAndStartSearch(BibEntry entry) {
        VBox citingVBox = new VBox();
        VBox citedByVBox = new VBox();
        citingVBox.setFillWidth(true);
        citedByVBox.setFillWidth(true);
        citingVBox.setAlignment(Pos.TOP_CENTER);
        citedByVBox.setAlignment(Pos.TOP_CENTER);
        AnchorPane citingHBox = new AnchorPane();
        citingHBox.setPrefHeight(40.0);
        AnchorPane citedByHBox = new AnchorPane();
        citedByHBox.setPrefHeight(40.0);
        Label citingLabel = new Label(Localization.lang("Cites", new Object[0]));
        this.styleLabel(citingLabel);
        Label citedByLabel = new Label(Localization.lang("Cited By", new Object[0]));
        this.styleLabel(citedByLabel);
        CheckListView citingListView = new CheckListView();
        CheckListView citedByListView = new CheckListView();
        Button refreshCitingButton = IconTheme.JabRefIcons.REFRESH.asButton();
        refreshCitingButton.setTooltip(new Tooltip(Localization.lang("Restart search", new Object[0])));
        this.styleTopBarNode((Node)refreshCitingButton, 15.0);
        Button refreshCitedByButton = IconTheme.JabRefIcons.REFRESH.asButton();
        refreshCitedByButton.setTooltip(new Tooltip(Localization.lang("Restart search", new Object[0])));
        this.styleTopBarNode((Node)refreshCitedByButton, 15.0);
        Button abortCitingButton = IconTheme.JabRefIcons.CLOSE.asButton();
        abortCitingButton.getGraphic().resize(30.0, 30.0);
        abortCitingButton.setTooltip(new Tooltip(Localization.lang("Cancel search", new Object[0])));
        this.styleTopBarNode((Node)abortCitingButton, 15.0);
        Button abortCitedButton = IconTheme.JabRefIcons.CLOSE.asButton();
        abortCitedButton.getGraphic().resize(30.0, 30.0);
        abortCitedButton.setTooltip(new Tooltip(Localization.lang("Cancel search", new Object[0])));
        this.styleTopBarNode((Node)abortCitedButton, 15.0);
        ProgressIndicator citingProgress = new ProgressIndicator();
        citingProgress.setMaxSize(25.0, 25.0);
        this.styleTopBarNode((Node)citingProgress, 50.0);
        ProgressIndicator citedByProgress = new ProgressIndicator();
        citedByProgress.setMaxSize(25.0, 25.0);
        this.styleTopBarNode((Node)citedByProgress, 50.0);
        Button importCitingButton = IconTheme.JabRefIcons.ADD_ENTRY.asButton();
        importCitingButton.setTooltip(new Tooltip(Localization.lang("Add selected entries to database", new Object[0])));
        this.styleTopBarNode((Node)importCitingButton, 50.0);
        Button importCitedByButton = IconTheme.JabRefIcons.ADD_ENTRY.asButton();
        importCitedByButton.setTooltip(new Tooltip(Localization.lang("Add selected entries to database", new Object[0])));
        this.styleTopBarNode((Node)importCitedByButton, 50.0);
        this.hideNodes(new Node[]{importCitingButton, importCitedByButton});
        citingHBox.getChildren().addAll((Object[])new Node[]{citingLabel, refreshCitingButton, importCitingButton, citingProgress, abortCitingButton});
        citedByHBox.getChildren().addAll((Object[])new Node[]{citedByLabel, refreshCitedByButton, importCitedByButton, citedByProgress, abortCitedButton});
        VBox.setVgrow((Node)citingListView, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)citedByListView, (Priority)Priority.ALWAYS);
        citingVBox.getChildren().addAll((Object[])new Node[]{citingHBox, citingListView});
        citedByVBox.getChildren().addAll((Object[])new Node[]{citedByHBox, citedByListView});
        refreshCitingButton.setOnMouseClicked(event -> this.searchForRelations(entry, (CheckListView<CitationRelationItem>)citingListView, abortCitingButton, refreshCitingButton, CitationFetcher.SearchType.CITES, importCitingButton, citingProgress, true));
        refreshCitedByButton.setOnMouseClicked(event -> this.searchForRelations(entry, (CheckListView<CitationRelationItem>)citedByListView, abortCitedButton, refreshCitedByButton, CitationFetcher.SearchType.CITED_BY, importCitedByButton, citedByProgress, true));
        SplitPane container = new SplitPane(new Node[]{citingVBox, citedByVBox});
        this.styleFetchedListView((CheckListView<CitationRelationItem>)citedByListView);
        this.styleFetchedListView((CheckListView<CitationRelationItem>)citingListView);
        this.searchForRelations(entry, (CheckListView<CitationRelationItem>)citingListView, abortCitingButton, refreshCitingButton, CitationFetcher.SearchType.CITES, importCitingButton, citingProgress, false);
        this.searchForRelations(entry, (CheckListView<CitationRelationItem>)citedByListView, abortCitedButton, refreshCitedByButton, CitationFetcher.SearchType.CITED_BY, importCitedByButton, citedByProgress, false);
        return container;
    }

    private void styleFetchedListView(CheckListView<CitationRelationItem> listView) {
        PseudoClass entrySelected = PseudoClass.getPseudoClass((String)"selected");
        new ViewModelListCellFactory().withGraphic(entry -> {
            HBox separator = new HBox();
            HBox.setHgrow((Node)separator, (Priority)Priority.SOMETIMES);
            Node entryNode = BibEntryView.getEntryNode(entry.entry());
            HBox.setHgrow((Node)entryNode, (Priority)Priority.ALWAYS);
            HBox hContainer = new HBox();
            hContainer.prefWidthProperty().bind((ObservableValue)listView.widthProperty().subtract(25));
            VBox vContainer = new VBox();
            if (entry.isLocal()) {
                hContainer.getStyleClass().add((Object)"duplicate-entry");
                Button jumpTo = IconTheme.JabRefIcons.LINK.asButton();
                jumpTo.setTooltip(new Tooltip(Localization.lang("Jump to entry in library", new Object[0])));
                jumpTo.getStyleClass().add((Object)"addEntryButton");
                jumpTo.setOnMouseClicked(event -> {
                    citingTask.cancel();
                    citedByTask.cancel();
                    this.libraryTab.showAndEdit(entry.localEntry());
                    this.libraryTab.clearAndSelect(entry.localEntry());
                });
                vContainer.getChildren().add((Object)jumpTo);
            } else {
                ToggleButton addToggle = IconTheme.JabRefIcons.ADD.asToggleButton();
                addToggle.setTooltip(new Tooltip(Localization.lang("Select entry", new Object[0])));
                EasyBind.subscribe((ObservableValue)addToggle.selectedProperty(), selected -> {
                    if (selected.booleanValue()) {
                        addToggle.setGraphic(IconTheme.JabRefIcons.ADD_FILLED.withColor(IconTheme.SELECTED_COLOR).getGraphicNode());
                    } else {
                        addToggle.setGraphic(IconTheme.JabRefIcons.ADD.getGraphicNode());
                    }
                });
                addToggle.getStyleClass().add((Object)"addEntryButton");
                addToggle.selectedProperty().bindBidirectional((Property)listView.getItemBooleanProperty(entry));
                vContainer.getChildren().add((Object)addToggle);
            }
            if (entry.entry().getDOI().isPresent() || entry.entry().getField(StandardField.URL).isPresent()) {
                Button openWeb = IconTheme.JabRefIcons.OPEN_LINK.asButton();
                openWeb.setTooltip(new Tooltip(Localization.lang("Open URL or DOI", new Object[0])));
                openWeb.setOnMouseClicked(event -> {
                    String url = entry.entry().getDOI().flatMap(DOI::getExternalURI).map(URI::toString).or(() -> entry.entry().getField(StandardField.URL)).orElse("");
                    if (StringUtil.isNullOrEmpty(url)) {
                        return;
                    }
                    try {
                        JabRefDesktop.openBrowser(url, this.preferencesService.getFilePreferences());
                    }
                    catch (IOException ex) {
                        this.dialogService.notify(Localization.lang("Unable to open link.", new Object[0]));
                    }
                });
                vContainer.getChildren().addLast((Object)openWeb);
            }
            hContainer.getChildren().addAll((Object[])new Node[]{entryNode, separator, vContainer});
            hContainer.getStyleClass().add((Object)"entry-container");
            return hContainer;
        }).withOnMouseClickedEvent((ee, event) -> {
            if (!ee.isLocal()) {
                listView.getCheckModel().toggleCheckState(ee);
            }
        }).withPseudoClass(entrySelected, (Callback<CitationRelationItem, ObservableValue<Boolean>>)((Callback)arg_0 -> listView.getItemBooleanProperty(arg_0))).install((ListView<CitationRelationItem>)listView);
        listView.setSelectionModel(new NoSelectionModel());
    }

    private void styleLabel(Label label) {
        label.setStyle("-fx-padding: 5px");
        label.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)label, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)label, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)label, (Double)0.0);
        AnchorPane.setRightAnchor((Node)label, (Double)0.0);
    }

    private void styleTopBarNode(Node node, double offset) {
        AnchorPane.setTopAnchor((Node)node, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)offset);
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return true;
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.setContent((Node)this.getPaneAndStartSearch(entry));
    }

    private void searchForRelations(BibEntry entry, CheckListView<CitationRelationItem> listView, Button abortButton, Button refreshButton, CitationFetcher.SearchType searchType, Button importButton, ProgressIndicator progress, boolean shouldRefresh) {
        BackgroundTask<List> task;
        if (entry.getDOI().isEmpty()) {
            this.hideNodes(new Node[]{abortButton, progress});
            this.showNodes(new Node[]{refreshButton});
            listView.getItems().clear();
            listView.setPlaceholder((Node)new Label(Localization.lang("The selected entry doesn't have a DOI linked to it. Lookup a DOI and try again.", new Object[0])));
            return;
        }
        ObservableList observableList = FXCollections.observableArrayList();
        listView.setItems(observableList);
        if (citingTask != null && !citingTask.isCanceled() && searchType == CitationFetcher.SearchType.CITES) {
            citingTask.cancel();
        } else if (citedByTask != null && !citedByTask.isCanceled() && searchType == CitationFetcher.SearchType.CITED_BY) {
            citedByTask.cancel();
        }
        if (searchType == CitationFetcher.SearchType.CITES) {
            task = BackgroundTask.wrap(() -> {
                if (shouldRefresh) {
                    this.bibEntryRelationsRepository.forceRefreshReferences(entry);
                }
                return this.bibEntryRelationsRepository.getReferences(entry);
            });
            citingTask = task;
        } else {
            task = BackgroundTask.wrap(() -> {
                if (shouldRefresh) {
                    this.bibEntryRelationsRepository.forceRefreshCitations(entry);
                }
                return this.bibEntryRelationsRepository.getCitations(entry);
            });
            citedByTask = task;
        }
        task.onRunning(() -> this.prepareToSearchForRelations(abortButton, refreshButton, importButton, progress, task)).onSuccess(fetchedList -> this.onSearchForRelationsSucceed(entry, listView, abortButton, refreshButton, searchType, importButton, progress, (List<BibEntry>)fetchedList, (ObservableList<CitationRelationItem>)observableList)).onFailure(exception -> {
            LOGGER.error("Error while fetching citing Articles", (Throwable)exception);
            this.hideNodes(new Node[]{abortButton, progress, importButton});
            listView.setPlaceholder((Node)new Label(Localization.lang("Error while fetching citing entries: %0", exception.getMessage())));
            refreshButton.setVisible(true);
            this.dialogService.notify(exception.getMessage());
        }).executeWith(this.taskExecutor);
    }

    private void onSearchForRelationsSucceed(BibEntry entry, CheckListView<CitationRelationItem> listView, Button abortButton, Button refreshButton, CitationFetcher.SearchType searchType, Button importButton, ProgressIndicator progress, List<BibEntry> fetchedList, ObservableList<CitationRelationItem> observableList) {
        this.hideNodes(new Node[]{abortButton, progress});
        observableList.setAll(fetchedList.stream().map(entr -> this.duplicateCheck.containsDuplicate(this.databaseContext.getDatabase(), (BibEntry)entr, BibDatabaseModeDetection.inferMode(this.databaseContext.getDatabase())).map(localEntry -> new CitationRelationItem((BibEntry)entr, (BibEntry)localEntry, true)).orElseGet(() -> new CitationRelationItem((BibEntry)entr, false))).toList());
        if (!observableList.isEmpty()) {
            listView.refresh();
        } else {
            Label placeholder = new Label(Localization.lang("No articles found", new Object[0]));
            listView.setPlaceholder((Node)placeholder);
        }
        BooleanBinding booleanBind = Bindings.isEmpty((ObservableList)listView.getCheckModel().getCheckedItems());
        importButton.disableProperty().bind((ObservableValue)booleanBind);
        importButton.setOnMouseClicked(event -> this.importEntries((List<CitationRelationItem>)listView.getCheckModel().getCheckedItems(), searchType, entry));
        this.showNodes(new Node[]{refreshButton, importButton});
    }

    private void prepareToSearchForRelations(Button abortButton, Button refreshButton, Button importButton, ProgressIndicator progress, BackgroundTask<List<BibEntry>> task) {
        this.showNodes(new Node[]{abortButton, progress});
        this.hideNodes(new Node[]{refreshButton, importButton});
        abortButton.setOnAction(event -> {
            this.hideNodes(new Node[]{abortButton, progress, importButton});
            this.showNodes(new Node[]{refreshButton});
            task.cancel();
            this.dialogService.notify(Localization.lang("Search aborted!", new Object[0]));
        });
    }

    private void hideNodes(Node ... nodes) {
        Arrays.stream(nodes).forEach(node -> node.setVisible(false));
    }

    private void showNodes(Node ... nodes) {
        Arrays.stream(nodes).forEach(node -> node.setVisible(true));
    }

    private void importEntries(List<CitationRelationItem> entriesToImport, CitationFetcher.SearchType searchType, BibEntry existingEntry) {
        citingTask.cancel();
        citedByTask.cancel();
        this.citationsRelationsTabViewModel.importEntries(entriesToImport, searchType, existingEntry);
        this.dialogService.notify(Localization.lang("Number of entries successfully imported", new Object[0]) + ": " + entriesToImport.size());
    }
}

