/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.copyormovecontent;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabViewModel;
import org.jabref.gui.edit.automaticfiededitor.LastAutomaticFieldEditorEdit;
import org.jabref.gui.edit.automaticfiededitor.MoveFieldValueAction;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;

public class CopyOrMoveFieldContentTabViewModel
extends AbstractAutomaticFieldEditorTabViewModel {
    public static final int TAB_INDEX = 1;
    private final ObjectProperty<Field> fromField = new SimpleObjectProperty((Object)StandardField.ABSTRACT);
    private final ObjectProperty<Field> toField = new SimpleObjectProperty((Object)StandardField.AUTHOR);
    private final BooleanProperty overwriteFieldContent = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private final List<BibEntry> selectedEntries;
    private final Validator toFieldValidator;
    private final BooleanBinding canMove;
    private final BooleanBinding canSwap;

    public CopyOrMoveFieldContentTabViewModel(List<BibEntry> selectedEntries, BibDatabase bibDatabase, StateManager stateManager) {
        super(bibDatabase, stateManager);
        this.selectedEntries = new ArrayList<BibEntry>(selectedEntries);
        this.toFieldValidator = new FunctionBasedValidator(this.toField, field -> {
            if (StringUtil.isBlank(field.getName())) {
                return ValidationMessage.error((String)"Field name cannot be empty");
            }
            if (StringUtil.containsWhitespace(field.getName())) {
                return ValidationMessage.error((String)"Field name cannot have whitespace characters");
            }
            return null;
        });
        this.canMove = BooleanBinding.booleanExpression((ObservableBooleanValue)this.toFieldValidationStatus().validProperty()).and((ObservableBooleanValue)this.overwriteFieldContentProperty());
        this.canSwap = BooleanBinding.booleanExpression((ObservableBooleanValue)this.toFieldValidationStatus().validProperty()).and((ObservableBooleanValue)this.overwriteFieldContentProperty());
    }

    public ValidationStatus toFieldValidationStatus() {
        return this.toFieldValidator.getValidationStatus();
    }

    public BooleanBinding canMoveProperty() {
        return this.canMove;
    }

    public BooleanBinding canSwapProperty() {
        return this.canSwap;
    }

    public Field getFromField() {
        return (Field)this.fromField.get();
    }

    public ObjectProperty<Field> fromFieldProperty() {
        return this.fromField;
    }

    public Field getToField() {
        return (Field)this.toField.get();
    }

    public ObjectProperty<Field> toFieldProperty() {
        return this.toField;
    }

    public boolean isOverwriteFieldContent() {
        return this.overwriteFieldContent.get();
    }

    public BooleanProperty overwriteFieldContentProperty() {
        return this.overwriteFieldContent;
    }

    public void copyValue() {
        NamedCompound copyFieldValueEdit = new NamedCompound("COPY_FIELD_VALUE");
        int affectedEntriesCount = 0;
        for (BibEntry entry : this.selectedEntries) {
            String fromFieldValue = entry.getField((Field)this.fromField.get()).orElse("");
            String toFieldValue = entry.getField((Field)this.toField.get()).orElse("");
            if (!this.overwriteFieldContent.get() && !StringUtil.isBlank(toFieldValue) || !StringUtil.isNotBlank(fromFieldValue)) continue;
            entry.setField((Field)this.toField.get(), fromFieldValue);
            copyFieldValueEdit.addEdit(new UndoableFieldChange(entry, (Field)this.toField.get(), toFieldValue, fromFieldValue));
            ++affectedEntriesCount;
        }
        if (copyFieldValueEdit.hasEdits()) {
            copyFieldValueEdit.end();
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 1, copyFieldValueEdit));
    }

    public void moveValue() {
        NamedCompound moveEdit = new NamedCompound("MOVE_EDIT");
        int affectedEntriesCount = 0;
        if (this.overwriteFieldContent.get()) {
            affectedEntriesCount = new MoveFieldValueAction((Field)this.fromField.get(), (Field)this.toField.get(), this.selectedEntries, moveEdit).executeAndGetAffectedEntriesCount();
            if (moveEdit.hasEdits()) {
                moveEdit.end();
            }
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 1, moveEdit));
    }

    public void swapValues() {
        NamedCompound swapFieldValuesEdit = new NamedCompound("SWAP_FIELD_VALUES");
        int affectedEntriesCount = 0;
        for (BibEntry entry : this.selectedEntries) {
            String fromFieldValue = entry.getField((Field)this.fromField.get()).orElse("");
            String toFieldValue = entry.getField((Field)this.toField.get()).orElse("");
            if (!this.overwriteFieldContent.get() || !StringUtil.isNotBlank(fromFieldValue) || !StringUtil.isNotBlank(toFieldValue)) continue;
            entry.setField((Field)this.toField.get(), fromFieldValue);
            entry.setField((Field)this.fromField.get(), toFieldValue);
            swapFieldValuesEdit.addEdit(new UndoableFieldChange(entry, (Field)this.toField.get(), toFieldValue, fromFieldValue));
            swapFieldValuesEdit.addEdit(new UndoableFieldChange(entry, (Field)this.fromField.get(), fromFieldValue, toFieldValue));
            ++affectedEntriesCount;
        }
        if (swapFieldValuesEdit.hasEdits()) {
            swapFieldValuesEdit.end();
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 1, swapFieldValuesEdit));
    }

    public List<BibEntry> getSelectedEntries() {
        return this.selectedEntries;
    }
}

