/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.preferences.ExternalApplicationsPreferences;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class JabRefDesktop {
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefDesktop.class);
    private static final NativeDesktop NATIVE_DESKTOP = OS.getNativeDesktop();
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");

    private JabRefDesktop() {
    }

    /*
     * Exception decompiling
     */
    public static void openExternalViewer(BibDatabaseContext databaseContext, PreferencesService preferencesService, String initialLink, Field initialField, DialogService dialogService, BibEntry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=9,552
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void openDoi(String doi, PreferencesService preferencesService) throws IOException {
        String link = DOI.parse(doi).map(DOI::getURIAsASCIIString).orElse(doi);
        JabRefDesktop.openBrowser(link, preferencesService.getFilePreferences());
    }

    public static void openCustomDoi(String link, PreferencesService preferences, DialogService dialogService) {
        DOI.parse(link).flatMap(doi -> doi.getExternalURIWithCustomBase(preferences.getDOIPreferences().getDefaultBaseURI())).ifPresent(uri -> {
            try {
                JabRefDesktop.openBrowser(uri, preferences.getFilePreferences());
            }
            catch (IOException e) {
                dialogService.showErrorDialogAndWait(Localization.lang("Unable to open link.", new Object[0]), e);
            }
        });
    }

    private static void openIsbn(String isbn, PreferencesService preferencesService) throws IOException {
        String link = "https://openlibrary.org/isbn/" + isbn;
        JabRefDesktop.openBrowser(link, preferencesService.getFilePreferences());
    }

    public static boolean openExternalFileAnyFormat(BibDatabaseContext databaseContext, FilePreferences filePreferences, String link, Optional<ExternalFileType> type) throws IOException {
        if (REMOTE_LINK_PATTERN.matcher(link.toLowerCase(Locale.ROOT)).matches()) {
            JabRefDesktop.openBrowser(link, filePreferences);
            return true;
        }
        Optional<Path> file = FileUtil.find(databaseContext, link, filePreferences);
        if (file.isPresent() && Files.exists(file.get(), new LinkOption[0])) {
            String filePath = file.get().toString();
            JabRefDesktop.openExternalFilePlatformIndependent(type, filePath, filePreferences);
            return true;
        }
        JabRefDesktop.openExternalFilePlatformIndependent(type, link, filePreferences);
        return true;
    }

    private static void openExternalFilePlatformIndependent(Optional<ExternalFileType> fileType, String filePath, FilePreferences filePreferences) throws IOException {
        if (fileType.isPresent()) {
            String application = fileType.get().getOpenWithApplication();
            if (application.isEmpty()) {
                NATIVE_DESKTOP.openFile(filePath, fileType.get().getExtension(), filePreferences);
            } else {
                NATIVE_DESKTOP.openFileWithApplication(filePath, application);
            }
        } else {
            NATIVE_DESKTOP.openFile(filePath, "", filePreferences);
        }
    }

    public static void openFolderAndSelectFile(Path fileLink, ExternalApplicationsPreferences externalApplicationsPreferences, DialogService dialogService) throws IOException {
        if (fileLink == null) {
            return;
        }
        boolean useCustomFileBrowser = externalApplicationsPreferences.useCustomFileBrowser();
        if (!useCustomFileBrowser) {
            NATIVE_DESKTOP.openFolderAndSelectFile(fileLink);
            return;
        }
        String absolutePath = fileLink.toAbsolutePath().getParent().toString();
        String command = externalApplicationsPreferences.getCustomFileBrowserCommand();
        if (command.isEmpty()) {
            LOGGER.info("No custom file browser command defined");
            NATIVE_DESKTOP.openFolderAndSelectFile(fileLink);
            return;
        }
        JabRefDesktop.executeCommand(command, absolutePath, dialogService);
    }

    public static void openConsole(Path file, PreferencesService preferencesService, DialogService dialogService) throws IOException {
        if (file == null) {
            return;
        }
        String absolutePath = file.toAbsolutePath().getParent().toString();
        boolean useCustomTerminal = preferencesService.getExternalApplicationsPreferences().useCustomTerminal();
        if (!useCustomTerminal) {
            NATIVE_DESKTOP.openConsole(absolutePath, dialogService);
            return;
        }
        String command = preferencesService.getExternalApplicationsPreferences().getCustomTerminalCommand();
        if ((command = command.trim()).isEmpty()) {
            NATIVE_DESKTOP.openConsole(absolutePath, dialogService);
            LOGGER.info("Preference for custom terminal is empty. Using default terminal.");
            return;
        }
        JabRefDesktop.executeCommand(command, absolutePath, dialogService);
    }

    private static void executeCommand(String command, String absolutePath, DialogService dialogService) {
        command = command.replaceAll("\\s+", " ");
        command = command.replace("%DIR", absolutePath);
        LOGGER.info("Executing command \"{}\"...", (Object)command);
        dialogService.notify(Localization.lang("Executing command \"%0\"...", command));
        String[] subcommands = command.split(" ");
        try {
            new ProcessBuilder(subcommands).start();
        }
        catch (IOException exception) {
            LOGGER.error("Error during command execution", (Throwable)exception);
            dialogService.notify(Localization.lang("Error occurred while executing the command \"%0\".", command));
        }
    }

    public static void openBrowser(String url, FilePreferences filePreferences) throws IOException {
        Optional<ExternalFileType> fileType = ExternalFileTypes.getExternalFileTypeByExt("html", filePreferences);
        JabRefDesktop.openExternalFilePlatformIndependent(fileType, url, filePreferences);
    }

    public static void openBrowser(URI url, FilePreferences filePreferences) throws IOException {
        JabRefDesktop.openBrowser(url.toASCIIString(), filePreferences);
    }

    public static void openBrowserShowPopup(String url, DialogService dialogService, FilePreferences filePreferences) {
        try {
            JabRefDesktop.openBrowser(url, filePreferences);
        }
        catch (IOException exception) {
            ClipBoardManager clipBoardManager = (ClipBoardManager)Injector.instantiateModelOrService(ClipBoardManager.class);
            clipBoardManager.setContent(url);
            LOGGER.error("Could not open browser", (Throwable)exception);
            String couldNotOpenBrowser = Localization.lang("Could not open browser.", new Object[0]);
            String openManually = Localization.lang("Please open %0 manually.", url);
            String copiedToClipboard = Localization.lang("The link has been copied to the clipboard.", new Object[0]);
            dialogService.notify(couldNotOpenBrowser);
            dialogService.showErrorDialogAndWait(couldNotOpenBrowser, couldNotOpenBrowser + "\n" + openManually + "\n" + copiedToClipboard);
        }
    }

    public static void moveToTrash(Path path) {
        NATIVE_DESKTOP.moveToTrash(path);
    }

    public static boolean moveToTrashSupported() {
        return NATIVE_DESKTOP.moveToTrashSupported();
    }

    public static Path getApplicationDirectory() {
        return NATIVE_DESKTOP.getApplicationDirectory();
    }

    public static Path getFulltextIndexBaseDirectory() {
        return NATIVE_DESKTOP.getFulltextIndexBaseDirectory();
    }
}

