/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeDetailsView;
import org.jabref.gui.collab.entryadd.EntryAdd;
import org.jabref.gui.collab.entrychange.EntryChange;
import org.jabref.gui.collab.entrychange.EntryChangeDetailsView;
import org.jabref.gui.collab.entrychange.EntryWithPreviewAndSourceDetailsView;
import org.jabref.gui.collab.entrydelete.EntryDelete;
import org.jabref.gui.collab.groupchange.GroupChange;
import org.jabref.gui.collab.groupchange.GroupChangeDetailsView;
import org.jabref.gui.collab.metedatachange.MetadataChange;
import org.jabref.gui.collab.metedatachange.MetadataChangeDetailsView;
import org.jabref.gui.collab.preamblechange.PreambleChange;
import org.jabref.gui.collab.preamblechange.PreambleChangeDetailsView;
import org.jabref.gui.collab.stringadd.BibTexStringAdd;
import org.jabref.gui.collab.stringadd.BibTexStringAddDetailsView;
import org.jabref.gui.collab.stringchange.BibTexStringChange;
import org.jabref.gui.collab.stringchange.BibTexStringChangeDetailsView;
import org.jabref.gui.collab.stringdelete.BibTexStringDelete;
import org.jabref.gui.collab.stringdelete.BibTexStringDeleteDetailsView;
import org.jabref.gui.collab.stringrename.BibTexStringRename;
import org.jabref.gui.collab.stringrename.BibTexStringRenameDetailsView;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public class DatabaseChangeDetailsViewFactory {
    private final BibDatabaseContext databaseContext;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final ThemeManager themeManager;
    private final PreferencesService preferencesService;
    private final BibEntryTypesManager entryTypesManager;
    private final PreviewViewer previewViewer;
    private final TaskExecutor taskExecutor;

    public DatabaseChangeDetailsViewFactory(BibDatabaseContext databaseContext, DialogService dialogService, StateManager stateManager, ThemeManager themeManager, PreferencesService preferencesService, BibEntryTypesManager entryTypesManager, PreviewViewer previewViewer, TaskExecutor taskExecutor) {
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.themeManager = themeManager;
        this.preferencesService = preferencesService;
        this.entryTypesManager = entryTypesManager;
        this.previewViewer = previewViewer;
        this.taskExecutor = taskExecutor;
    }

    public DatabaseChangeDetailsView create(DatabaseChange databaseChange) {
        DatabaseChange databaseChange2 = databaseChange;
        Objects.requireNonNull(databaseChange2);
        DatabaseChange databaseChange3 = databaseChange2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryChange.class, EntryAdd.class, EntryDelete.class, BibTexStringAdd.class, BibTexStringDelete.class, BibTexStringChange.class, BibTexStringRename.class, MetadataChange.class, GroupChange.class, PreambleChange.class}, (Object)databaseChange3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                EntryChange entryChange = (EntryChange)databaseChange3;
                yield new EntryChangeDetailsView(entryChange.getOldEntry(), entryChange.getNewEntry(), this.databaseContext, this.dialogService, this.stateManager, this.themeManager, this.preferencesService, this.entryTypesManager, this.previewViewer, this.taskExecutor);
            }
            case 1 -> {
                EntryAdd entryAdd = (EntryAdd)databaseChange3;
                yield new EntryWithPreviewAndSourceDetailsView(entryAdd.getAddedEntry(), this.databaseContext, this.preferencesService, this.entryTypesManager, this.previewViewer);
            }
            case 2 -> {
                EntryDelete entryDelete = (EntryDelete)databaseChange3;
                yield new EntryWithPreviewAndSourceDetailsView(entryDelete.getDeletedEntry(), this.databaseContext, this.preferencesService, this.entryTypesManager, this.previewViewer);
            }
            case 3 -> {
                BibTexStringAdd stringAdd = (BibTexStringAdd)databaseChange3;
                yield new BibTexStringAddDetailsView(stringAdd);
            }
            case 4 -> {
                BibTexStringDelete stringDelete = (BibTexStringDelete)databaseChange3;
                yield new BibTexStringDeleteDetailsView(stringDelete);
            }
            case 5 -> {
                BibTexStringChange stringChange = (BibTexStringChange)databaseChange3;
                yield new BibTexStringChangeDetailsView(stringChange);
            }
            case 6 -> {
                BibTexStringRename stringRename = (BibTexStringRename)databaseChange3;
                yield new BibTexStringRenameDetailsView(stringRename);
            }
            case 7 -> {
                MetadataChange metadataChange = (MetadataChange)databaseChange3;
                yield new MetadataChangeDetailsView(metadataChange, this.preferencesService.getCitationKeyPatternPreferences().getKeyPatterns());
            }
            case 8 -> {
                GroupChange groupChange = (GroupChange)databaseChange3;
                yield new GroupChangeDetailsView(groupChange);
            }
            case 9 -> {
                PreambleChange preambleChange = (PreambleChange)databaseChange3;
                yield new PreambleChangeDetailsView(preambleChange);
            }
        };
    }
}

