/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Objects;
import java.util.stream.Stream;
import org.jabref.gui.autocompleter.StringSuggestionProvider;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.field.Field;

class FieldValueSuggestionProvider
extends StringSuggestionProvider {
    private final Field field;
    private final BibDatabase database;

    FieldValueSuggestionProvider(Field field, BibDatabase database) {
        this.field = Objects.requireNonNull(field);
        this.database = database;
    }

    @Override
    public Stream<String> getSource() {
        return this.database.getEntries().parallelStream().flatMap(entry -> entry.getField(this.field).stream());
    }
}

