/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jabref.gui.autocompleter.StringSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;

public class ContentSelectorSuggestionProvider
extends StringSuggestionProvider {
    private final SuggestionProvider<String> suggestionProvider;
    private final List<String> contentSelectorValues;

    public ContentSelectorSuggestionProvider(SuggestionProvider<String> suggestionProvider, List<String> contentSelectorValues) {
        this.suggestionProvider = suggestionProvider;
        this.contentSelectorValues = contentSelectorValues;
    }

    @Override
    public Stream<String> getSource() {
        return Stream.concat(this.contentSelectorValues.stream(), this.suggestionProvider.getSource());
    }

    @Override
    public List<String> getPossibleSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (this.suggestionProvider != null) {
            suggestions.addAll(this.suggestionProvider.getPossibleSuggestions());
        }
        suggestions.addAll(this.contentSelectorValues);
        return suggestions;
    }
}

