/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.templatepane;

import com.dlsc.gemsfx.incubator.templatepane.TemplatePaneSkin;
import com.dlsc.gemsfx.incubator.templatepane.Tile;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class TemplatePane
extends Control {
    private final ObservableMap<Position, Tile> tilesMap = FXCollections.observableHashMap();

    public TemplatePane() {
        for (Position pos : Position.values()) {
            Tile tile = new Tile(this, pos);
            this.tilesMap.put((Object)pos, (Object)tile);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new TemplatePaneSkin(this);
    }

    public final Tile setNode(Position pos, Node node) {
        Tile tile = (Tile)this.tilesMap.get((Object)pos);
        tile.setNode(node);
        this.getChildren().add((Object)node);
        node.setManaged(false);
        return tile;
    }

    public final Node getNode(Position pos) {
        return ((Tile)this.tilesMap.get((Object)pos)).getNode();
    }

    public final Tile getTile(Position pos) {
        return (Tile)this.tilesMap.get((Object)pos);
    }

    public static enum Position {
        ABOVE_HEADER,
        HEADER_LEFT,
        HEADER,
        HEADER_RIGHT,
        BELOW_HEADER,
        LEFT,
        RIGHT,
        ABOVE_SIDES,
        BELOW_SIDES,
        CONTENT_LEFT,
        CONTENT_RIGHT,
        ABOVE_CONTENT,
        BELOW_CONTENT,
        CONTENT,
        ABOVE_FOOTER,
        FOOTER_LEFT,
        FOOTER_RIGHT,
        FOOTER,
        BELOW_FOOTER,
        OVERLAY_TOP,
        OVERLAY_BOTTOM,
        OVERLAY_LEFT,
        OVERLAY_RIGHT;

    }
}

