/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.ResizableTextArea;
import com.dlsc.gemsfx.skins.LimitedTextAreaSkin;
import com.dlsc.gemsfx.util.IntegerRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.control.Skin;

public class LimitedTextArea
extends ResizableTextArea {
    private static final String DEFAULT_STYLE_CLASS = "limited-text-area";
    private static final boolean DEFAULT_SHOW_BOTTOM = true;
    private BooleanProperty showBottom;
    private final ObjectProperty<IntegerRange> characterRangeLimit = new SimpleObjectProperty((Object)this, "characterRangeLimit");
    private final ObservableList<String> excludedItems = FXCollections.observableArrayList();
    private final StringProperty tips = new SimpleStringProperty((Object)this, "tips");
    private final ReadOnlyBooleanWrapper outOfRange = new ReadOnlyBooleanWrapper((Object)this, "isOverLimit", false);
    private final ObjectProperty<LengthDisplayMode> lengthDisplayMode = new SimpleObjectProperty((Object)this, "lengthDisplayMode", (Object)LengthDisplayMode.AUTO);
    private final DoubleProperty warningThreshold = new SimpleDoubleProperty((Object)this, "warningThreshold", 0.9);

    public LimitedTextArea() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getStylesheets().add((Object)Objects.requireNonNull(LimitedTextArea.class.getResource("limited-text-area.css")).toExternalForm());
    }

    public LimitedTextArea(String text) {
        this();
        this.setText(text);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new LimitedTextAreaSkin(this, this.outOfRange);
    }

    public final BooleanProperty showBottomProperty() {
        if (this.showBottom == null) {
            this.showBottom = new StyleableBooleanProperty(true){

                public Object getBean() {
                    return LimitedTextArea.this;
                }

                public String getName() {
                    return "showBottom";
                }

                public CssMetaData<? extends Styleable, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_BOTTOM;
                }
            };
        }
        return this.showBottom;
    }

    public final boolean isShowBottom() {
        return this.showBottom == null ? true : this.showBottom.get();
    }

    public final void setShowBottom(boolean showBottom) {
        this.showBottomProperty().set(showBottom);
    }

    public final IntegerRange getCharacterRangeLimit() {
        return (IntegerRange)this.characterRangeLimit.get();
    }

    public final ObjectProperty<IntegerRange> characterRangeLimitProperty() {
        return this.characterRangeLimit;
    }

    public final void setCharacterRangeLimit(IntegerRange characterRangeLimit) {
        this.characterRangeLimit.set((Object)characterRangeLimit);
    }

    public final ObservableList<String> getExcludedItems() {
        return this.excludedItems;
    }

    public final String getTips() {
        return (String)this.tips.get();
    }

    public final StringProperty tipsProperty() {
        return this.tips;
    }

    public final void setTips(String tips) {
        this.tips.set((Object)tips);
    }

    public final boolean isOutOfRange() {
        return this.outOfRange.get();
    }

    public final ReadOnlyBooleanProperty outOfRangeProperty() {
        return this.outOfRange.getReadOnlyProperty();
    }

    private final void setOutOfRange(boolean outOfRange) {
        this.outOfRange.set(outOfRange);
    }

    public final LengthDisplayMode getLengthDisplayMode() {
        return (LengthDisplayMode)((Object)this.lengthDisplayMode.get());
    }

    public final ObjectProperty<LengthDisplayMode> lengthDisplayModeProperty() {
        return this.lengthDisplayMode;
    }

    public final void setLengthDisplayMode(LengthDisplayMode lengthDisplayMode) {
        this.lengthDisplayMode.set((Object)lengthDisplayMode);
    }

    public final double getWarningThreshold() {
        return this.warningThreshold.get();
    }

    public final DoubleProperty warningThresholdProperty() {
        return this.warningThreshold;
    }

    public final void setWarningThreshold(double warningThreshold) {
        this.warningThreshold.set(warningThreshold);
    }

    public final double getValidWarningThreshold() {
        return Math.min(Math.max(this.getWarningThreshold(), 0.0), 0.999999);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return LimitedTextArea.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public static enum LengthDisplayMode {
        AUTO,
        ALWAYS_SHOW,
        ALWAYS_HIDE;

    }

    private static class StyleableProperties {
        private static final CssMetaData<LimitedTextArea, Boolean> SHOW_BOTTOM = new CssMetaData<LimitedTextArea, Boolean>("-fx-show-bottom", BooleanConverter.getInstance(), Boolean.valueOf(true)){

            public StyleableProperty<Boolean> getStyleableProperty(LimitedTextArea control) {
                return (StyleableProperty)control.showBottomProperty();
            }

            public boolean isSettable(LimitedTextArea control) {
                return control.showBottom == null || !control.showBottom.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<LimitedTextArea, Boolean>> styleables = new ArrayList<CssMetaData<LimitedTextArea, Boolean>>(ResizableTextArea.getClassCssMetaData());
            styleables.add(SHOW_BOTTOM);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

